/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.service;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.inquiry.InquiryRestrictions;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.util.LegacyDataFramework;

/**
 * Responsible for using AttributeSecurity on
 * AttributeDefinitions, InquirableField the data dictionary business object and
 * maintenance document entries
 *
 * TODO: refactor for general objects
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Use {@link org.kuali.rice.krad.service.DataObjectAuthorizationService}.
 */
@Deprecated
@LegacyDataFramework
public interface BusinessObjectAuthorizationService extends DataObjectAuthorizationService {
	public BusinessObjectRestrictions getLookupResultRestrictions(
			Object dataObject, Person user);

	public InquiryRestrictions getInquiryRestrictions(
			BusinessObject businessObject, Person user);

	public MaintenanceDocumentRestrictions getMaintenanceDocumentRestrictions(
			MaintenanceDocument maintenanceDocument, Person user);

	public boolean canFullyUnmaskField(Person user,
			Class<?> dataObjectClass, String fieldName, Document document);

	public boolean canPartiallyUnmaskField(
			Person user, Class<?> businessObjectClass, String fieldName, Document document);

}
