/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.service;

import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.rules.rule.BusinessRule;

import java.util.Collection;

/**
 * This interface defines methods that a TransactionalDocumentDictionary Service must provide. Defines the API for the interacting
 * with TransactionalDocument-related entries in the data dictionary.
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public interface TransactionalDocumentDictionaryService {
    /**
     * Returns whether or not this document's data dictionary file has flagged it to allow document copies.
     * 
     * @param document
     * @return True if copies are allowed, false otherwise.
     */
    public Boolean getAllowsCopy(TransactionalDocument document);

    /**
     * Retrieves a document instance by it's class name.
     * 
     * @param documentTypeName
     * @return A document instance.
     */
    public Class getDocumentClassByName(String documentTypeName);

    /**
     * Retrieves the full description of the transactional document as described in its data dictionary entry.
     * 
     * @param transactionalDocumentTypeName
     * @return The transactional document's full description.
     */
    public String getDescription(String transactionalDocumentTypeName);

    /**
     * Retrieves the label for the transactional document as described in its data dictionary entry.
     * 
     * @param transactionalDocumentTypeName
     * @return The transactional document's label.
     */
    public String getLabel(String transactionalDocumentTypeName);


    /**
     * The collection of ReferenceDefinition objects defined as DefaultExistenceChecks for the MaintenanceDocument.
     * 
     * @param document
     * @return A Collection of ReferenceDefinitions
     */
    public Collection getDefaultExistenceChecks(TransactionalDocument document);

    /**
     * The collection of ReferenceDefinition objects defined as DefaultExistenceChecks for the MaintenanceDocument.
     * 
     * @param docTypeName
     * @return A Collection of ReferenceDefinitions
     */
    public Collection getDefaultExistenceChecks(String docTypeName);
}
