/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.MessageMap;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * An adapter whose subclasses will make either an {@link org.kuali.rice.krad.util.MessageMap}'s warning or info messages available to the JSP layer
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public abstract class MessageContainer implements Serializable {
	private MessageMap errorMap;
	
	protected MessageContainer(MessageMap errorMap) {
		this.errorMap = errorMap;
	}
	
	protected MessageMap getMessageMap() {
		return errorMap;
	}
	
    public ActionMessages getRequestMessages() {
        ActionMessages requestErrors = new ActionMessages();
        for (Iterator<String> iter = getMessagePropertyNames().iterator(); iter.hasNext();) {
            String property = iter.next();
            List errorList = (List) getMessagesForProperty(property);

            for (Iterator iterator = errorList.iterator(); iterator.hasNext();) {
                ErrorMessage errorMessage = (ErrorMessage) iterator.next();

                // add ActionMessage with any parameters
                requestErrors.add(property, new ActionMessage(errorMessage.getErrorKey(), errorMessage.getMessageParameters()));
            }
        }
        return requestErrors;
    }
    
    public abstract int getMessageCount();
    
    public abstract List<String> getMessagePropertyList();

    protected abstract Set<String> getMessagePropertyNames();
    
    protected abstract List getMessagesForProperty(String propertyName);
}
