/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.document.Document;

import java.util.List;
import java.util.ListIterator;

/**
 * @deprecated Use {@link org.kuali.rice.krad.util.RouteToCompletionUtil}.
 */
//Adhoc Document Complete functionality utility
@Deprecated
public class RouteToCompletionUtil {

    /***
     * Checks if there is atleast one Ad-Hoc Completion request for the document and based on that returns a boolean value.
     */
    public static boolean checkIfAtleastOneAdHocCompleteRequestExist(Document document) {
        boolean foundAtleastOneCompleteReq = false;
        // iterating the adhoc recpients list to check if there is atleast on complete request for the document.
        foundAtleastOneCompleteReq = loopAndCheckValue(document.getAdHocRouteWorkgroups()) || loopAndCheckValue(document.getAdHocRoutePersons());
        return foundAtleastOneCompleteReq;
    }

    /***
     * Loops and checks if the required value is present in the loop used for checking if there is atleast one adhoc completion
     * request present for a person or work group
     */
    public static boolean loopAndCheckValue(List adhoc) {
        if (adhoc == null) {
            return false;
        }
        ListIterator<AdHocRouteRecipient> groupIter = adhoc.listIterator();
        String valueToCheck = null;
        AdHocRouteRecipient recipient = null;
        boolean foundAtleastOneCompleteReq = false;
        while (groupIter.hasNext()) {
            recipient = groupIter.next();
            valueToCheck = recipient.getActionRequested();
            if (StringUtils.isNotEmpty(valueToCheck)) {
                if (KewApiConstants.ACTION_REQUEST_COMPLETE_REQ.equals(valueToCheck)) {
                    foundAtleastOneCompleteReq = true;
                    break;
                }
            }
        }
        return foundAtleastOneCompleteReq;
    }
}
