/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import org.apache.struts.action.ActionForward;


public class PostTransactionActionForward extends ActionForward {
    
    protected ActionForwardCallback callback;
    protected ActionForward realForward;

    public PostTransactionActionForward() {
    }

    public PostTransactionActionForward(final ActionForward copyMe, final ActionForwardCallback callback) {
        super(copyMe);
        setRealForward(copyMe);
        setCallback(callback);
    }

    public PostTransactionActionForward(final String path, final ActionForwardCallback callback) {
        super(path);
        setCallback(callback);
    }

    public PostTransactionActionForward(final String path, final ActionForwardCallback callback, boolean redirect) {
        super(path, redirect);
        setCallback(callback);
    }

    public PostTransactionActionForward(final String name, final ActionForwardCallback callback, final String path, boolean redirect) {
        super(name, path, redirect);
        setCallback(callback);
    }
    
    public void setCallback(final ActionForwardCallback callback) {
        this.callback = callback;
    }
    public ActionForwardCallback getCallback() {
        return callback;
    }

    public ActionForward getRealForward() {
        return this.realForward;
    }

    public void setRealForward(final ActionForward realForward) {
        this.realForward = realForward;
    }
}
