/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao.proxy;

import java.sql.Timestamp;

import org.kuali.rice.krad.bo.SessionDocument;
import org.kuali.rice.krad.dao.SessionDocumentDao;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SessionDocumentDaoProxy implements SessionDocumentDao {

	private SessionDocumentDao sessionDocumentDaoJpa;
    private SessionDocumentDao sessionDocumentDaoOjb;
	
    private SessionDocumentDao getDao(Class clazz) {
    	return LegacyUtils.useLegacy(clazz) ? sessionDocumentDaoOjb : sessionDocumentDaoJpa;
    }
    
	public void setSessionDocumentDaoJpa(SessionDocumentDao sessionDocumentDaoJpa) {
		this.sessionDocumentDaoJpa = sessionDocumentDaoJpa;
	}

	public void setSessionDocumentDaoOjb(SessionDocumentDao sessionDocumentDaoOjb) {
		this.sessionDocumentDaoOjb = sessionDocumentDaoOjb;
	}

	@Override
    public void purgeAllSessionDocuments(Timestamp expirationDate) {
	    	getDao(SessionDocument.class).purgeAllSessionDocuments(expirationDate);
	    }

}
