/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kns.datadictionary.CollectionDefinitionI;
import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.FieldDefinitionI;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.util.MaintenanceUtils;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

@Deprecated
public class FieldBridge {
    private static final Logger LOG = LogManager.getLogger(FieldBridge.class);
    private static DataDictionaryService dataDictionaryService;
    private static PersistenceStructureService persistenceStructureService;
    private static BusinessObjectDictionaryService businessObjectDictionaryService;
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;

    public static void setupField(Field field, FieldDefinitionI definition, Set<String> conditionallyRequiredMaintenanceFields) {
        if (definition instanceof MaintainableFieldDefinition) {
            MaintainableFieldDefinition maintainableFieldDefinition = (MaintainableFieldDefinition)definition;
            field.setFieldRequired(maintainableFieldDefinition.isRequired());
            field.setReadOnly(maintainableFieldDefinition.isUnconditionallyReadOnly());
            if (maintainableFieldDefinition.isLookupReadOnly()) {
                field.setFieldType("lookupreadonly");
            }
            if (StringUtils.isNotBlank((String)maintainableFieldDefinition.getWebUILeaveFieldFunction())) {
                field.setWebOnBlurHandler(maintainableFieldDefinition.getWebUILeaveFieldFunction());
            }
            if (StringUtils.isNotBlank((String)maintainableFieldDefinition.getWebUILeaveFieldCallbackFunction())) {
                field.setWebOnBlurHandlerCallback(maintainableFieldDefinition.getWebUILeaveFieldCallbackFunction());
            }
            if (maintainableFieldDefinition.getWebUILeaveFieldFunctionParameters() != null) {
                field.setWebUILeaveFieldFunctionParameters(maintainableFieldDefinition.getWebUILeaveFieldFunctionParameters());
            }
            if (StringUtils.isNotBlank((String)maintainableFieldDefinition.getAlternateDisplayAttributeName())) {
                field.setAlternateDisplayPropertyName(maintainableFieldDefinition.getAlternateDisplayAttributeName());
            }
            if (StringUtils.isNotBlank((String)maintainableFieldDefinition.getAdditionalDisplayAttributeName())) {
                field.setAdditionalDisplayPropertyName(maintainableFieldDefinition.getAdditionalDisplayAttributeName());
            }
            if (conditionallyRequiredMaintenanceFields != null && conditionallyRequiredMaintenanceFields.contains(field.getPropertyName())) {
                field.setFieldRequired(true);
            }
            if (((MaintainableFieldDefinition)definition).isTriggerOnChange()) {
                field.setTriggerOnChange(true);
            }
        }
    }

    public static void populateFieldFromBusinessObject(Field field, BusinessObject bo) {
        if (bo == null) {
            throw new RuntimeException("Inquiry Business object is null.");
        }
        field.setReadOnly(true);
        Formatter formatter = field.getFormatter();
        String propertyName = field.getPropertyName();
        ControlDefinition fieldControl = FieldBridge.getDataDictionaryService().getAttributeControlDefinition(bo.getClass(), propertyName);
        try {
            String propValue;
            Object prop = ObjectUtils.getPropertyValue(bo, field.getPropertyName());
            if (fieldControl != null && fieldControl.isSelect() && StringUtils.isBlank((String)field.getAdditionalDisplayPropertyName()) && StringUtils.isBlank((String)field.getAlternateDisplayPropertyName())) {
                Class keyValuesFinderName = ClassLoaderUtils.getClass((String)fieldControl.getValuesFinderClass(), KeyValuesFinder.class);
                KeyValuesFinder finder = (KeyValuesFinder)keyValuesFinderName.newInstance();
                if (!CollectionUtils.isEmpty((Map)fieldControl.getValuesFinderProperties())) {
                    for (Map.Entry entry : fieldControl.getValuesFinderProperties().entrySet()) {
                        BeanUtils.setProperty((Object)finder, (String)((String)entry.getKey()), entry.getValue());
                    }
                }
                if (formatter != null) {
                    prop = ObjectUtils.getFormattedPropertyValue(bo, propertyName, formatter);
                }
                propValue = FieldBridge.lookupFinderValue(fieldControl, prop, finder);
            } else {
                propValue = ObjectUtils.getFormattedPropertyValue(bo, field.getPropertyName(), formatter);
            }
            field.setPropertyValue(propValue);
            if (StringUtils.isNotBlank((String)field.getAlternateDisplayPropertyName())) {
                String alternatePropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, field.getAlternateDisplayPropertyName());
                field.setAlternateDisplayPropertyValue(alternatePropertyValue);
            }
            if (StringUtils.isNotBlank((String)field.getAdditionalDisplayPropertyName())) {
                String additionalPropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, field.getAdditionalDisplayPropertyName());
                field.setAdditionalDisplayPropertyValue(additionalPropertyValue);
            }
            if (fieldControl != null && fieldControl.isKualiUser()) {
                try {
                    Object personName;
                    Object principalId;
                    if (StringUtils.isNotBlank((String)field.getUniversalIdAttributeName()) && (principalId = ObjectUtils.getNestedValue(bo, field.getUniversalIdAttributeName())) != null) {
                        field.setUniversalIdValue(principalId.toString());
                    }
                    if (StringUtils.isNotBlank((String)field.getPersonNameAttributeName()) && (personName = ObjectUtils.getNestedValue(bo, field.getPersonNameAttributeName())) != null) {
                        field.setPersonNameValue(personName.toString());
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Unable to get principal ID or person name property in FieldBridge.", (Throwable)ex);
                }
            }
            if (fieldControl != null && fieldControl.isFile() && "file".equals(field.getFieldType())) {
                field.setImageSrc(WebUtils.getAttachmentImageForUrl(FieldUtils.getContentType(field, bo)));
                field.setPropertyValue(FieldUtils.getFileName(field, bo));
            }
            FieldUtils.setInquiryURL(field, bo, propertyName);
        }
        catch (ClassNotFoundException | InstantiationException | InvocationTargetException e) {
            LOG.error("Unable to get instance of KeyValuesFinder: " + e.getMessage());
            throw new RuntimeException("Unable to get instance of KeyValuesFinder: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Unable to set columns: " + e.getMessage());
            throw new RuntimeException("Unable to set columns: " + e.getMessage(), e);
        }
    }

    private static String lookupFinderValue(ControlDefinition fieldControl, Object prop, KeyValuesFinder finder) {
        List keyValues = finder.getKeyValues();
        String propValue = FieldBridge.getPropertyValueFromList(prop, keyValues);
        if (propValue == null) {
            propValue = FieldBridge.lookupInactiveFinderValue(prop, finder);
        }
        return propValue;
    }

    private static String lookupInactiveFinderValue(Object property, KeyValuesFinder finder) {
        List keyValues = finder.getKeyValues(false);
        return FieldBridge.getPropertyValueFromList(property, keyValues);
    }

    private static String getPropertyValueFromList(Object property, List<KeyValue> keyValues) {
        String propertyValue = null;
        if (property != null) {
            for (KeyValue element2 : keyValues) {
                KeyValue element = element2;
                if (!element.getKey().equals(property.toString())) continue;
                propertyValue = element.getValue();
                break;
            }
        }
        return propertyValue;
    }

    protected static boolean isMaintenanceFieldLevelHelpEnabled(Maintainable m, MaintainableFieldDefinition fieldDefinition) {
        if (fieldDefinition != null) {
            return fieldDefinition.isShowFieldLevelHelp() != null && fieldDefinition.isShowFieldLevelHelp() != false;
        }
        return false;
    }

    protected static boolean isMaintenanceFieldLevelHelpDisabled(Maintainable m, MaintainableFieldDefinition fieldDefinition) {
        if (fieldDefinition != null) {
            return fieldDefinition.isShowFieldLevelHelp() != null && fieldDefinition.isShowFieldLevelHelp() == false;
        }
        return false;
    }

    public static Field toField(MaintainableItemDefinition id, MaintainableSectionDefinition sd, BusinessObject o, Maintainable m, Section s, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields) throws InstantiationException, IllegalAccessException {
        Field field = new Field();
        if (id instanceof MaintainableFieldDefinition) {
            MaintainableFieldDefinition maintainableFieldDefinition = (MaintainableFieldDefinition)id;
            field = FieldUtils.getPropertyField(o.getClass(), maintainableFieldDefinition.getName(), false);
            boolean translateCodes = FieldBridge.getMaintenanceDocumentDictionaryService().translateCodes(o.getClass());
            if (translateCodes) {
                FieldUtils.setAdditionalDisplayPropertyForCodes(o.getClass(), field.getPropertyName(), field);
            }
            FieldBridge.setupField(field, maintainableFieldDefinition, conditionallyRequiredMaintenanceFields);
            MaintenanceUtils.setFieldQuickfinder(o, field.getPropertyName(), maintainableFieldDefinition, field, displayedFieldNames, m);
            MaintenanceUtils.setFieldDirectInquiry(o, field.getPropertyName(), maintainableFieldDefinition, field, displayedFieldNames);
            field.setFieldLevelHelpEnabled(FieldBridge.isMaintenanceFieldLevelHelpEnabled(m, maintainableFieldDefinition));
            field.setFieldLevelHelpDisabled(FieldBridge.isMaintenanceFieldLevelHelpDisabled(m, maintainableFieldDefinition));
            field.setFieldLevelHelpUrl(maintainableFieldDefinition.getFieldLevelHelpUrl());
        }
        return field;
    }

    public static List<Field> getNewFormFields(CollectionDefinitionI collectionDefinition, BusinessObject o, Maintainable m, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, String parents, boolean hideAdd, int numberOfColumns) {
        PersistableBusinessObject collBO;
        LOG.debug("getNewFormFields");
        String collName = collectionDefinition.getName();
        List<Field> collFields = new ArrayList<Field>();
        try {
            List<? extends FieldDefinitionI> collectionFields = collectionDefinition.getFields();
            collBO = m.getNewCollectionLine(parents + collName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("newBO for add line: " + collBO);
            }
            for (FieldDefinitionI fieldDefinitionI : collectionFields) {
                Field collField = FieldUtils.getPropertyField(collectionDefinition.getBusinessObjectClass(), fieldDefinitionI.getName(), false);
                if (fieldDefinitionI instanceof MaintainableFieldDefinition) {
                    FieldBridge.setupField(collField, fieldDefinitionI, conditionallyRequiredMaintenanceFields);
                }
                String[] nameParts = StringUtils.split((String)collField.getPropertyName(), (String)".");
                Object fieldErrorKey = "document.newMaintainableObject.add.";
                fieldErrorKey = (String)fieldErrorKey + collName + ".";
                for (int i = 0; i < nameParts.length; ++i) {
                    fieldErrorKey = (String)fieldErrorKey + nameParts[i];
                    containerRowErrorKey.append((String)fieldErrorKey);
                    if (i >= nameParts.length) continue;
                    fieldErrorKey = (String)fieldErrorKey + ".";
                    containerRowErrorKey.append(",");
                }
                BusinessObject collectionBoInstance = collectionDefinition.getBusinessObjectClass().newInstance();
                FieldUtils.setInquiryURL(collField, collectionBoInstance, fieldDefinitionI.getName());
                if (collectionDefinition instanceof MaintainableCollectionDefinition) {
                    MaintenanceUtils.setFieldQuickfinder(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                    MaintenanceUtils.setFieldDirectInquiry(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                } else {
                    LookupUtils.setFieldQuickfinder(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m);
                    LookupUtils.setFieldDirectInquiry(collectionBoInstance, fieldDefinitionI.getName(), collField);
                }
                collFields.add(collField);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Unable to create instance of object class" + e.getMessage());
            throw new RuntimeException("Unable to create instance of object class" + e.getMessage(), e);
        }
        collFields = FieldUtils.populateFieldsFromBusinessObject(collFields, collBO);
        for (Field field : collFields) {
            field.setPropertyName("add." + parents + collectionDefinition.getName() + "." + field.getPropertyName());
        }
        LOG.debug("Error Key for section " + collectionDefinition.getName() + " : " + containerRowErrorKey.toString());
        collFields = FieldBridge.constructContainerField(collectionDefinition, parents, o, hideAdd, numberOfColumns, collName, collFields);
        return collFields;
    }

    public static List<Field> constructContainerField(CollectionDefinitionI collectionDefinition, String parents, BusinessObject o, boolean hideAdd, int numberOfColumns, String collName, List<Field> collFields) {
        String collectionLabel = FieldBridge.getDataDictionaryService().getCollectionLabel(o.getClass(), collectionDefinition.getName());
        String collectionElementLabel = collectionDefinition.getSummaryTitle();
        if (StringUtils.isEmpty((String)collectionElementLabel)) {
            collectionElementLabel = FieldBridge.getDataDictionaryService().getCollectionElementLabel(o.getClass().getName(), collectionDefinition.getName(), collectionDefinition.getBusinessObjectClass());
        }
        Field containerField = FieldUtils.constructContainerField(collName, collectionLabel, collFields, numberOfColumns);
        if (StringUtils.isNotEmpty((String)collectionElementLabel)) {
            containerField.setContainerElementName(collectionElementLabel);
        }
        collFields = new ArrayList<Field>();
        collFields.add(containerField);
        if (!hideAdd && collectionDefinition.getIncludeAddLine()) {
            Field field = new Field();
            String addButtonName = "methodToCall.addLine." + parents + collectionDefinition.getName() + ".(!!" + collectionDefinition.getBusinessObjectClass().getName() + "!!)";
            field.setPropertyName(addButtonName);
            field.setFieldType("imagesubmit");
            field.setPropertyValue("images/tinybutton-add1.gif");
            containerField.getContainerRows().add(new Row(field));
        }
        if (collectionDefinition instanceof MaintainableCollectionDefinition && FieldUtils.isCollectionMultipleLookupEnabled((MaintainableCollectionDefinition)collectionDefinition)) {
            FieldUtils.modifyFieldToSupportMultipleValueLookups(containerField, parents, (MaintainableCollectionDefinition)collectionDefinition);
        }
        return collFields;
    }

    public static List<Field> getNewFormFields(MaintainableCollectionDefinition collectionDefinition, BusinessObject o, Maintainable m, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, int numberOfColumns) {
        String parent = "";
        return FieldBridge.getNewFormFields(collectionDefinition, o, m, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, parent, false, numberOfColumns);
    }

    public static Field toField(FieldDefinition d, BusinessObject o, Section s) {
        String additionalDisplayPropertyName;
        Field field = FieldUtils.getPropertyField(o.getClass(), d.getAttributeName(), false);
        FieldUtils.setInquiryURL(field, o, field.getPropertyName());
        String alternateDisplayPropertyName = FieldBridge.getBusinessObjectDictionaryService().getInquiryFieldAlternateDisplayAttributeName(o.getClass(), d.getAttributeName());
        if (StringUtils.isNotBlank((String)alternateDisplayPropertyName)) {
            field.setAlternateDisplayPropertyName(alternateDisplayPropertyName);
        }
        if (StringUtils.isNotBlank((String)(additionalDisplayPropertyName = FieldBridge.getBusinessObjectDictionaryService().getInquiryFieldAdditionalDisplayAttributeName(o.getClass(), d.getAttributeName())))) {
            field.setAdditionalDisplayPropertyName(additionalDisplayPropertyName);
        } else {
            boolean translateCodes = FieldBridge.getBusinessObjectDictionaryService().tranlateCodesInInquiry(o.getClass());
            if (translateCodes) {
                FieldUtils.setAdditionalDisplayPropertyForCodes(o.getClass(), d.getAttributeName(), field);
            }
        }
        FieldBridge.populateFieldFromBusinessObject(field, o);
        return field;
    }

    public static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KNSServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }

    public static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (businessObjectDictionaryService == null) {
            businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return businessObjectDictionaryService;
    }

    public static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }
}

