/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.criteria;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.criteria.CriteriaLookupDao;
import org.kuali.rice.krad.criteria.CriteriaLookupDaoOjb;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;

public class CriteriaLookupDaoProxy
implements CriteriaLookupDao {
    CriteriaLookupDao criteriaLookupDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static Map<String, CriteriaLookupDao> lookupDaoValues;

    public void setCriteriaLookupDaoOjb(CriteriaLookupDao lookupDaoOjb) {
        this.criteriaLookupDaoOjb = lookupDaoOjb;
    }

    private CriteriaLookupDao getDao(Class clazz) {
        ModuleService moduleService = CriteriaLookupDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (lookupDaoValues.get(dataSourceName) != null) {
                    return lookupDaoValues.get(dataSourceName);
                }
                CriteriaLookupDaoOjb classSpecificLookupDaoOjb = new CriteriaLookupDaoOjb();
                classSpecificLookupDaoOjb.setJcdAlias(dataSourceName);
                lookupDaoValues.put(dataSourceName, classSpecificLookupDaoOjb);
                return classSpecificLookupDaoOjb;
            }
        }
        return this.criteriaLookupDaoOjb;
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria) {
        return this.getDao(queryClass).lookup(queryClass, criteria);
    }

    @Override
    public <T> GenericQueryResults<T> lookup(Class<T> queryClass, QueryByCriteria criteria, LookupCustomizer<T> customizer) {
        return this.getDao(queryClass).lookup(queryClass, criteria, customizer);
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        lookupDaoValues = Collections.synchronizedMap(new HashMap());
    }
}

