/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.RedirectingActionForward;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.inquiry.Inquirable;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.InquiryForm;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

@Deprecated
public class KualiInquiryAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(KualiInquiryAction.class);
    private NoteService noteService;

    @Override
    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        if (!(form instanceof InquiryForm)) {
            super.checkAuthorization(form, methodToCall);
        } else {
            try {
                if (!"downloadBOAttachment".equals(methodToCall)) {
                    Class<?> businessObjectClass = Class.forName(((InquiryForm)form).getBusinessObjectClassName());
                    if (!KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPrincipalId(), "KR-NS", "Inquire Into Records", KRADUtils.getNamespaceAndComponentSimpleName(businessObjectClass), Collections.emptyMap())) {
                        throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "inquire", businessObjectClass.getSimpleName());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unable to load BusinessObject class: " + ((InquiryForm)form).getBusinessObjectClassName(), (Throwable)e);
                super.checkAuthorization(form, methodToCall);
            }
        }
    }

    @Override
    protected Map<String, String> getRoleQualification(ActionForm form, String methodToCall) {
        Map<String, String> primaryKeys;
        Map<String, String> roleQualification = super.getRoleQualification(form, methodToCall);
        if (form instanceof InquiryForm && (primaryKeys = ((InquiryForm)form).getInquiryPrimaryKeys()) != null) {
            for (String keyName : primaryKeys.keySet()) {
                roleQualification.put(keyName, primaryKeys.get(keyName));
            }
        }
        return roleQualification;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("maintenanceViewMode", (Object)"inquiry");
        return super.execute(mapping, form, request, response);
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        Class<?> boClass = Class.forName(inquiryForm.getBusinessObjectClassName());
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(boClass)) {
            String redirectUrl = responsibleModuleService.getExternalizableBusinessObjectInquiryUrl(boClass, request.getParameterMap());
            RedirectingActionForward redirectingActionForward = new RedirectingActionForward(redirectUrl);
            redirectingActionForward.setModule("/");
            return redirectingActionForward;
        }
        return this.continueWithInquiry(mapping, form, request, response);
    }

    public ActionForward downloadAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormFile att;
        InquiryForm inquiryForm = (InquiryForm)form;
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        String downloadAttachmentPath = request.getParameter("downloadAttachmentPath");
        if (StringUtils.isNotBlank((String)downloadAttachmentPath) && (att = (FormFile)PropertyUtils.getNestedProperty((Object)bo, (String)downloadAttachmentPath)) != null) {
            this.streamToResponse(att.getFileData(), att.getFileName(), att.getContentType(), response);
            return null;
        }
        int line = this.getSelectedLine(request);
        if (line < 0) {
            PersistableAttachment attachment;
            if (bo instanceof PersistableAttachment && StringUtils.isNotBlank((String)(attachment = (PersistableAttachment)bo).getFileName()) && attachment.getAttachmentContent() != null) {
                this.streamToResponse(attachment.getAttachmentContent(), attachment.getFileName(), attachment.getContentType(), response);
            }
        } else if (bo instanceof PersistableAttachmentList) {
            PersistableAttachmentList attachmentsBo = (PersistableAttachmentList)bo;
            if (CollectionUtils.isEmpty((Collection)attachmentsBo.getAttachments())) {
                return null;
            }
            List attachments = attachmentsBo.getAttachments();
            if (CollectionUtils.isNotEmpty((Collection)attachments) && attachments.size() > line) {
                PersistableAttachment attachment = (PersistableAttachment)attachmentsBo.getAttachments().get(line);
                this.streamToResponse(attachment.getAttachmentContent(), attachment.getFileName(), attachment.getContentType(), response);
            }
        }
        return null;
    }

    public ActionForward downloadCustomBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = request.getParameter("fileName");
        String contentType = request.getParameter("contentType");
        String fileContentBoField = request.getParameter("fileContentBOField");
        if (fileName != null && contentType != null && fileContentBoField != null) {
            this.checkAuthorization(form, this.findMethodToCall(form, request));
            fileName = StringUtils.replace((String)fileName, (String)" ", (String)"_");
            InquiryForm inquiryForm = (InquiryForm)form;
            BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
            this.checkBO(bo);
            Class clazz = bo.getClass();
            Method method = clazz.getMethod("get" + StringUtils.capitalize((String)fileContentBoField), new Class[0]);
            byte[] fileContents = (byte[])method.invoke((Object)bo, new Object[0]);
            this.streamToResponse(fileContents, fileName, contentType, response);
        } else {
            if (fileName == null) {
                LOG.error("Request Parameter \"fileName\" not provided.");
            }
            if (contentType == null) {
                LOG.error("Request Parameter \"contentType\" not provided.");
            }
            if (fileContentBoField == null) {
                LOG.error("Request Parameter \"fileContentBOField\" not provided.");
            }
        }
        return null;
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("noteIdentifier") == null) {
            return this.downloadBONote(mapping, form, request, response);
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!this.canViewBONotes(user)) {
            throw new AuthorizationException(user.getPrincipalName(), "download notes", "inquiry");
        }
        Long noteIdentifier = Long.valueOf(request.getParameter("noteIdentifier"));
        Note note = this.getNoteService().getNoteByNoteId(noteIdentifier);
        if (note != null) {
            Attachment attachment = note.getAttachment();
            if (attachment != null) {
                attachment.setNote(note);
                WebUtils.saveMimeInputStreamAsFile(response, attachment.getAttachmentMimeTypeCode(), attachment.getAttachmentContents(), attachment.getAttachmentFileName(), attachment.getAttachmentFileSize().intValue());
            }
            return null;
        }
        return mapping.findForward("basic");
    }

    protected boolean canViewBONotes(Person user) {
        return KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "View Note / Attachment", Map.of(), Map.of());
    }

    public ActionForward continueWithInquiry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        if (bo instanceof GloballyUnique) {
            inquiryForm.setBoNotes(this.getNoteService().getByRemoteObjectId(((GloballyUnique)bo).getObjectId()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward downloadBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!this.canViewBONotes(user)) {
            throw new AuthorizationException(user.getPrincipalName(), "download notes", "inquiry");
        }
        int attachmentIndex = this.selectedAttachmentIndex(request);
        if (attachmentIndex >= 0 && attachmentIndex < inquiryForm.getBoNotes().size()) {
            Note note = inquiryForm.getBoNotes().get(attachmentIndex);
            Attachment attachment = note.getAttachment();
            attachment.setNote(note);
            inquiryForm.copyPopulateEditablePropertiesToActionEditableProperties();
            WebUtils.saveMimeInputStreamAsFile(response, attachment.getAttachmentMimeTypeCode(), attachment.getAttachmentContents(), attachment.getAttachmentFileName(), attachment.getAttachmentFileSize().intValue());
            return null;
        }
        return mapping.findForward("basic");
    }

    protected int selectedAttachmentIndex(HttpServletRequest request) {
        int attachmentIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String attachmentIndexParam = StringUtils.substringBetween((String)parameterName, (String)".attachment[", (String)"].");
            try {
                attachmentIndex = Integer.parseInt(attachmentIndexParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attachmentIndex;
    }

    public ActionForward toggleInactiveRecordDisplay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        String collectionName = this.extractCollectionName(request, "toggleInactiveRecordDisplay");
        if (collectionName == null) {
            LOG.error("Unable to get find collection name in request.");
            throw new RuntimeException("Unable to get find collection class in request.");
        }
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        boolean showInactive = Boolean.parseBoolean(StringUtils.substringBetween((String)parameterName, (String)"(!!", (String)"."));
        kualiInquirable.setShowInactiveRecords(collectionName, showInactive);
        this.populateSections(mapping, request, inquiryForm, bo);
        if (showInactive) {
            WebUtils.reopenInactiveRecords(inquiryForm.getSections(), inquiryForm.getTabStates(), collectionName);
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        inquiryForm.getInquirable();
        return super.toggleTab(mapping, form, request, response);
    }

    @Override
    public ActionForward hideAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        return super.hideAllTabs(mapping, form, request, response);
    }

    @Override
    public ActionForward showAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.getBusinessObjectClassName() == null) {
            LOG.error("Business object name not given.");
            throw new RuntimeException("Business object name not given.");
        }
        BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
        this.checkBO(bo);
        this.populateSections(mapping, request, inquiryForm, bo);
        return super.showAllTabs(mapping, form, request, response);
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InquiryForm inquiryForm = (InquiryForm)form;
        if (inquiryForm.isCanExport()) {
            BusinessObject bo = this.retrieveBOFromInquirable(inquiryForm);
            this.checkBO(bo);
            if (bo != null) {
                BusinessObjectEntry businessObjectEntry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryForm.getBusinessObjectClassName());
                Class exporterClass = businessObjectEntry.getExporterClass();
                if (exporterClass != null) {
                    Exporter exporter = (Exporter)exporterClass.newInstance();
                    response.setContentType("application/xml");
                    response.setHeader("Content-disposition", "attachment; filename=export.xml");
                    exporter.export(businessObjectEntry.getBusinessObjectClass(), Collections.singletonList(bo), "xml", (OutputStream)response.getOutputStream());
                }
            } else {
                this.populateSections(mapping, request, inquiryForm, bo);
                return mapping.findForward("basic");
            }
        }
        return null;
    }

    protected String extractCollectionName(HttpServletRequest request, String methodToCall) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String collectionName = null;
        if (StringUtils.isNotBlank((String)parameterName)) {
            collectionName = StringUtils.substringBetween((String)parameterName, (String)(methodToCall + "."), (String)".(");
        }
        return collectionName;
    }

    protected BusinessObject retrieveBOFromInquirable(InquiryForm inquiryForm) {
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        BusinessObject bo = kualiInquirable.getBusinessObject(inquiryForm.retrieveInquiryDecryptedPrimaryKeys());
        if (bo == null) {
            LOG.error("No records found in inquiry action.");
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inquiry", new String[0]);
        }
        return bo;
    }

    protected void populateSections(ActionMapping mapping, HttpServletRequest request, InquiryForm inquiryForm, BusinessObject bo) {
        Inquirable kualiInquirable = inquiryForm.getInquirable();
        if (bo != null) {
            List<Section> sections = kualiInquirable.getSections(bo);
            inquiryForm.setSections(sections);
            kualiInquirable.addAdditionalSections(sections, bo);
        } else {
            inquiryForm.setSections(this.getEmptySections(kualiInquirable.getTitle()));
        }
        request.setAttribute("kualiInquirable", (Object)kualiInquirable);
    }

    protected void streamToResponse(byte[] fileContents, String fileName, String fileContentType, HttpServletResponse response) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(fileContents.length);){
            baos.write(fileContents);
            WebUtils.saveMimeOutputStreamAsFile(response, fileContentType, baos, fileName);
        }
    }

    private List<Section> getEmptySections(String title) {
        Row row = new Row(Collections.emptyList());
        Section section = new Section(Collections.singletonList(row));
        section.setErrorKey("*");
        section.setSectionTitle(title != null ? title : "");
        section.setNumberOfColumns(0);
        return Collections.singletonList(section);
    }

    private void checkBO(BusinessObject bo) {
        if (bo == null && GlobalVariables.getMessageMap().hasNoMessages()) {
            throw new UnsupportedOperationException("The record you have inquired on does not exist.");
        }
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }
}

