/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.accesslayer.sql.SelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

/**
 * SqlGeneratorDefaultImpl subclass that replaced the vanilla SqlSelectStatement implementation
 * with a new {@link SuffixedSqlSelectStatement} that is {@link SuffixableQueryByCriteria} - aware.
 * This class needs to be specified as the SqlGenerator implementation in the OJB properties, to replace
 * the SqlGeneratorDefaultImpl.
 * This is a hack to introduce select-for-update functionality into OJB so the same ORM/Criteria abstractions
 * can be retained for select-for-update queries.  Select for update appears to have been added in the OJB
 * source repository, so maybe a forthcoming release will include this functionality and these kludges can be
 * removed.
 * @see SuffixedSqlSelectStatement
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Deprecated
public class SqlGeneratorSuffixableImpl extends SqlGeneratorDefaultImpl {
    private Logger logger = LoggerFactory.getLogger(SqlGeneratorSuffixableImpl.class);

    public SqlGeneratorSuffixableImpl(Platform platform) {
        super(platform);
    }

    @Override
    public SelectStatement getPreparedSelectStatement(Query query, ClassDescriptor cld) {
        SelectStatement sql = new SuffixedSqlSelectStatement(getPlatform(), cld, query, logger);
        if (logger.isDebugEnabled()) {
            boolean masochisticSqlLogging = true;
            if ( masochisticSqlLogging ) {
            	logger.debug("SQL: " + sql.getStatement() + "\n" + query.getCriteria() + "\nFor platform: " + getPlatform().getClass().toString() + "\n" + ExceptionUtils.getStackTrace(new Throwable()));
            } else {
                logger.debug("SQL: " + sql.getStatement() );
            }
        }
        return sql;
    }
}
