/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb.conversion;

import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

/**
 * This class originates from a similar class in the Kuali Financial System and has been adapted from 
 * that original state which was originally authored by the Kuali Nervous System team.
 * 
 * For records in the KEW tables, "0" and "1" are used to represent "false" and "true"
 * respectively which is the standard way to represent these values in OJB.
 * This differs from other pieces of the KNS where "N" and "Y" are used.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class OjbCharBooleanConversion3 implements FieldConversion {
    
	/**
     * This handles checking any incoming String value and converts them
     * to the appropriate Boolean value. 
     * @see FieldConversion#javaToSql(Object)
     */
    @Override
    public Object javaToSql(Object source) {
        if (source instanceof String) {
            if ("Y".equals(source)) {
                return Boolean.TRUE;
            }
            else if ("N".equals(source)) {
                return Boolean.FALSE;
            }
        }
        return source;
    }

    @Override
    public Object sqlToJava(Object source) {
        return source;
    }
}
