/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.kuali.rice.krad.util.MessageMap;

import java.util.List;
import java.util.Set;

/**
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class InfoContainer extends MessageContainer {
	public InfoContainer(MessageMap errorMap) {
		super(errorMap);
	}
	
	/**
	 * @see MessageContainer#getMessageCount()
	 */
	@Override
	public int getMessageCount() {
		return getMessageMap().getInfoCount();
	}

	/**
	 * @see MessageContainer#getMessagePropertyList()
	 */
	@Override
	public List<String> getMessagePropertyList() {
		return getMessageMap().getPropertiesWithInfo();
	}

	/**
	 * @see MessageContainer#getMessagePropertyNames()
	 */
	@Override
	protected Set<String> getMessagePropertyNames() {
		return getMessageMap().getAllPropertiesWithInfo();
	}

	/**
	 * @see MessageContainer#getMessagesForProperty(java.lang.String)
	 */
	@Override
	protected List getMessagesForProperty(String propertyName) {
		return getMessageMap().getInfoMessagesForProperty(propertyName);
	}

}
