/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.web.struts.form.KualiFeedbackHandlerForm;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiFeedbackService;
import org.kuali.rice.krad.util.KRADConstants;

/**
 * This class handles when the feedback form is submitted.
 * It invokes the KualiFeedbackService to send the feedback email
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class KualiFeedbackHandlerAction extends KualiAction {

	@Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (findMethodToCall(form, request) == null || findMethodToCall(form, request).equals("docHandler")) {
			return executeFeedback(mapping, form, request, response);
		}
		else {
			return super.execute(mapping, form, request, response);
		}
	}

	public ActionForward executeFeedback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ActionForward returnForward = null;
		KualiFeedbackHandlerForm formObject = (KualiFeedbackHandlerForm) form;
		if (!formObject.isCancel()) {
			populateRequest(form, request);
			returnForward = mapping.findForward(RiceConstants.MAPPING_BASIC);
		}
		else {
			returnForward = mapping.findForward(KRADConstants.MAPPING_CANCEL);
		}

		return returnForward;
	}

	public ActionForward submitFeedback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (form instanceof KualiFeedbackHandlerForm) {
			KualiFeedbackHandlerForm feedbackForm = (KualiFeedbackHandlerForm) form;
			KualiFeedbackService reporterService = KRADServiceLocatorWeb.getKualiFeedbackService();
			reporterService.sendFeedback(feedbackForm.getDocumentId(), feedbackForm.getComponentName(), feedbackForm.getDescription());
		}
		return mapping.findForward(KRADConstants.MAPPING_CLOSE);
	}

	private void populateRequest(ActionForm form, HttpServletRequest request) {
		UserSession userSession = (UserSession) request.getSession().getAttribute(KRADConstants.USER_SESSION_KEY);
		Person sessionUser = null;
		if (userSession != null) {
			sessionUser = userSession.getPerson();
		}
		if (sessionUser != null) {
			request.setAttribute("principalName", sessionUser.getPrincipalName());
		}
	}

	@Override
	protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
	}
}
