/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.krad.util.KRADConstants;

/**
 * Feedback form which is used to collect feedback from a user and
 * then email it to a feedback mailing list
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class KualiFeedbackHandlerForm extends KualiForm {

	private static final long serialVersionUID = -7641833777580490471L;

	private boolean cancel = false;
	private String description;
	private String documentId = ""; 
	private String componentName;

	/**
	 * @see org.kuali.rice.kns.web.struts.pojo.PojoForm#populate(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public void populate(HttpServletRequest request) {
		super.populate(request);
		// ie explorer needs this.
		if(StringUtils.isNotBlank(request.getParameter(KRADConstants.CANCEL_METHOD + ".x")) &&
           StringUtils.isNotBlank(request.getParameter(KRADConstants.CANCEL_METHOD + ".y"))){
			    this.setCancel(true);
		}                
	}

	@Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {

		this.setMethodToCall(null);
		this.setRefreshCaller(null);
		this.setAnchor(null);
		this.setCurrentTabIndex(0);

		this.cancel = false;
		this.documentId = null;
		this.description = null;
		this.componentName = null;
	}

	public boolean isCancel() {
		return cancel;
	}

	public void setCancel(boolean cancel) {
		this.cancel = cancel;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDocumentId() {
		return documentId;
	}

	public void setDocumentId(String documentId) {
		this.documentId = documentId;
	}

	public String getComponentName() {
		return componentName;
	}

	public void setComponentName(String componentName) {
		this.componentName = componentName;
	}
}
