/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import java.util.Collection;
import java.util.Map;


/**
 * This class provides collection retrievals to populate key value pairs of business objects.
 *
 *
 */
@Deprecated
public interface KeyValuesService {

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     *
     * @param clazz
     * @return
     */
    public <T> Collection<T> findAll(Class<T> clazz);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type. Performs a sort on the result collection on the given sort
     * field.
     *
     * @param clazz
     * @param sortField - name of the field in the class to sort results by
     * @param sortAscending - boolean indicating whether to sort ascending or descending
     * @return
     */
    public <T> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name and its expected value.
     *
     * @param clazz
     * @param fieldValues
     * @return
     */
    public <T> Collection<T> findMatching(Class<T> clazz, Map<String, Object> fieldValues);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     *
     * @param clazz
     * @return
     */
    public <T> Collection<T> findAllInactive(Class<T> clazz);

}
