/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.jdbc;

import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.persistence.jdbc.dao.PlatformAwareDaoBaseJdbc;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.SequenceAccessorDao;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springmodules.orm.ojb.OjbFactoryUtils;

@Deprecated
public class SequenceAccessorDaoJdbc
extends PlatformAwareDaoBaseJdbc
implements SequenceAccessorDao {
    private KualiModuleService kualiModuleService;

    private Long nextAvailableSequenceNumber(String sequenceName, Class clazz) {
        ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService == null) {
            throw new ConfigurationException("moduleService is null");
        }
        ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
        if (moduleConfig == null) {
            throw new ConfigurationException("moduleConfiguration is null");
        }
        String dataSourceName = moduleConfig.getDataSourceName();
        if (StringUtils.isEmpty((String)dataSourceName)) {
            return this.nextAvailableSequenceNumber(sequenceName);
        }
        PBKey key = new PBKey(dataSourceName);
        PersistenceBroker broker = OjbFactoryUtils.getPersistenceBroker((PBKey)key, (boolean)false);
        if (broker != null) {
            return this.getDbPlatform().getNextValSQL(sequenceName, (Object)broker);
        }
        throw new ConfigurationException("PersistenceBroker is null");
    }

    private Long nextAvailableSequenceNumber(String sequenceName) {
        DataSource dataSource = (DataSource)ConfigContext.getCurrentContextConfig().getObject("kradApplication.datasource");
        if (dataSource == null) {
            dataSource = KRADServiceLocator.getKradApplicationDataSource();
        }
        return MaxValueIncrementerFactory.getIncrementer((DataSource)dataSource, (String)sequenceName).nextLongValue();
    }

    public Long getNextAvailableSequenceNumber(String sequenceName, Class clazz) {
        if (!LegacyUtils.useLegacy((Class)clazz)) {
            throw new ConfigurationException("SequenceAccessorService should not be used with new data framework! Use " + MaxValueIncrementerFactory.class.getName() + " instead.");
        }
        try {
            return this.nextAvailableSequenceNumber(sequenceName, clazz);
        }
        catch (ConfigurationException e) {
            return this.nextAvailableSequenceNumber(sequenceName);
        }
    }

    @Override
    public Long getNextAvailableSequenceNumber(String sequenceName) {
        return this.nextAvailableSequenceNumber(sequenceName);
    }

    private KualiModuleService getKualiModuleService() {
        if (this.kualiModuleService == null) {
            this.kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return this.kualiModuleService;
    }
}

