/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.indirection.ValueHolder;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.ForeignKeyFieldsPopulationState;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class KNSLegacyDataAdapterImpl
implements LegacyDataAdapter {
    private static final Logger LOG = LogManager.getLogger(KNSLegacyDataAdapterImpl.class);
    private static final Pattern VALUE_HOLDER_FIELD_PATTERN = Pattern.compile("^_persistence_(.*)_vh$");
    private final ConcurrentMap<Class<?>, List<ValueHolderFieldPair>> valueHolderFieldCache = new ConcurrentHashMap(8, 0.9f, 1);
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private LookupDao lookupDao;
    private DocumentDao documentDao;
    private PersistenceStructureService persistenceStructureService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private ConfigurationService kualiConfigurationService;
    private KualiModuleService kualiModuleService;
    private DataDictionaryService dataDictionaryService;

    public <T> T save(T dataObject) {
        if (dataObject instanceof Collection) {
            ArrayList newList = new ArrayList(((Collection)dataObject).size());
            for (Object obj : (Collection)dataObject) {
                newList.add(this.save(obj));
            }
            return (T)newList;
        }
        return (T)this.businessObjectService.save((PersistableBusinessObject)dataObject);
    }

    public void flush(Class<?> type) {
    }

    public <T> T linkAndSave(T dataObject) {
        return (T)this.businessObjectService.linkAndSave((PersistableBusinessObject)dataObject);
    }

    public <T> T saveDocument(T document) {
        return (T)this.documentDao.save((Document)document);
    }

    public <T> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        return this.businessObjectService.findByPrimaryKey(clazz, primaryKeys);
    }

    public <T> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return this.businessObjectService.findBySinglePrimaryKey(clazz, primaryKey);
    }

    public void delete(Object dataObject) {
        if (dataObject instanceof Collection) {
            for (Object dobj : (Collection)dataObject) {
                this.delete(dobj);
            }
        } else {
            this.businessObjectService.delete(dataObject);
        }
    }

    public <T> void deleteMatching(Class<T> type, Map<String, ?> fieldValues) {
        this.businessObjectService.deleteMatching(type, fieldValues);
    }

    public <T> T retrieve(T dataObject) {
        return (T)this.businessObjectService.retrieve(dataObject);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findMatching(clazz, Collections.emptyMap());
    }

    public <T> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest) {
        return this.findMatching(clazz, Collections.emptyMap(), pagingRequest);
    }

    public <T> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        return this.businessObjectService.findMatching(clazz, fieldValues);
    }

    public <T> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest) {
        return this.businessObjectService.findMatching(clazz, fieldValues, pagingRequest);
    }

    public <T> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        return this.businessObjectService.findMatchingOrderBy(clazz, fieldValues, sortField, sortAscending);
    }

    public <T> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        return this.businessObjectService.findMatchingOrderBy(clazz, fieldValues, sortField, sortAscending, pagingRequest);
    }

    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject) {
        return this.persistenceService.getPrimaryKeyFieldValues(dataObject);
    }

    public void retrieveNonKeyFields(Object persistableObject) {
        this.persistenceService.retrieveNonKeyFields(persistableObject);
        this.synchronizeEclipseLinkWeavings(persistableObject);
    }

    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        this.persistenceService.retrieveReferenceObject(persistableObject, referenceObjectName);
        this.synchronizeEclipseLinkWeavings(persistableObject, referenceObjectName);
    }

    public void refreshAllNonUpdatingReferences(Object persistableObject) {
        this.persistenceService.refreshAllNonUpdatingReferences((PersistableBusinessObject)persistableObject);
        this.synchronizeEclipseLinkWeavings(persistableObject);
    }

    public boolean isProxied(Object object) {
        if (!(object instanceof BusinessObject) && !(object instanceof PersistableBusinessObjectBaseAdapter)) {
            return false;
        }
        return this.persistenceService.isProxied(object);
    }

    public Object resolveProxy(Object o) {
        return this.persistenceService.resolveProxy(o);
    }

    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        return this.lookupDao.findCollectionBySearchHelper(dataObjectClass, formProperties, unbounded, allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties, List<String> wildcardAsLiteralPropertyNames, boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        return this.lookupDao.findCollectionBySearchHelper(dataObjectClass, formProperties, unbounded, allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    public <T> T findObjectBySearch(Class<T> type, Map<String, String> formProps) {
        return this.lookupDao.findObjectByMap(type, formProps);
    }

    public boolean allPrimaryKeyValuesPresentAndNotWildcard(Class<?> boClass, Map<String, String> formProps) {
        List<String> pkFields = this.listPrimaryKeyFieldNames(boClass);
        Iterator<String> pkIter = pkFields.iterator();
        boolean returnVal = true;
        block0: while (returnVal && pkIter.hasNext()) {
            String pkName = pkIter.next();
            String pkValue = formProps.get(pkName);
            if (StringUtils.isBlank((String)pkValue)) {
                returnVal = false;
                continue;
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                returnVal = false;
                continue block0;
            }
        }
        return returnVal;
    }

    public List<String> listPrimaryKeyFieldNames(Class<?> type) {
        List<String> keys = new ArrayList<String>();
        if (type == null) {
            return keys;
        }
        if (this.isPersistable(type)) {
            keys = this.persistenceStructureService.listPrimaryKeyFieldNames(type);
        } else {
            ModuleService responsibleModuleService = this.kualiModuleService.getResponsibleModuleService(type);
            if (responsibleModuleService != null && responsibleModuleService.isExternalizable(type)) {
                keys = responsibleModuleService.listPrimaryKeyFieldNames(type);
            } else {
                DataObjectEntry dataObjectEntry = this.dataDictionaryService.getDataDictionary().getDataObjectEntry(type.getName());
                if (dataObjectEntry != null) {
                    List pks = dataObjectEntry.getPrimaryKeys();
                    if (pks != null) {
                        keys = pks;
                    }
                } else {
                    LOG.warn("Unable to retrieve data object entry for non-persistable KNS-managed class: " + type.getName());
                }
            }
        }
        return keys;
    }

    public Class<?> determineCollectionObjectType(Class<?> containingType, String collectionPropertyName) {
        if (!this.isPersistable(containingType)) {
            throw new RuntimeException("Can't determine the Class of Collection elements because persistenceStructureService.isPersistable(" + containingType.getName() + ") returns false.");
        }
        Map<String, Class> collectionClasses = this.persistenceStructureService.listCollectionObjectTypes(containingType);
        Class collectionObjectType = collectionClasses.get(collectionPropertyName);
        return collectionObjectType;
    }

    public boolean hasReference(Class<?> boClass, String referenceName) {
        return this.persistenceStructureService.hasReference(boClass, referenceName);
    }

    public boolean hasCollection(Class<?> boClass, String collectionName) {
        return this.persistenceStructureService.hasCollection(boClass, collectionName);
    }

    public boolean isExtensionAttribute(Class<?> boClass, String attributePropertyName, Class<?> propertyType) {
        return propertyType.equals(PersistableBusinessObjectExtension.class);
    }

    public Class<?> getExtensionAttributeClass(Class<?> boClass, String attributePropertyName) {
        return this.persistenceStructureService.getBusinessObjectAttributeClass(boClass, attributePropertyName);
    }

    public Map<String, ?> getPrimaryKeyFieldValuesDOMDS(Object dataObject) {
        return this.dataObjectMetaDataService.getPrimaryKeyFieldValues(dataObject);
    }

    public boolean equalsByPrimaryKeys(Object do1, Object do2) {
        return this.dataObjectMetaDataService.equalsByPrimaryKeys(do1, do2);
    }

    public void materializeAllSubObjects(Object object) {
        ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)object);
    }

    public Class<?> getPropertyType(Object object, String propertyName) {
        return ObjectUtils.getPropertyType(object, propertyName, this.persistenceStructureService);
    }

    public Object getExtension(Class<?> businessObjectClass) throws InstantiationException, IllegalAccessException {
        Class<? extends PersistableBusinessObjectExtension> extensionClass = this.persistenceStructureService.getBusinessObjectAttributeClass(businessObjectClass, "extension");
        if (extensionClass != null) {
            return extensionClass.newInstance();
        }
        return null;
    }

    public void refreshReferenceObject(Object businessObject, String referenceObjectName) {
        if (StringUtils.isNotBlank((String)referenceObjectName) && !StringUtils.equals((String)referenceObjectName, (String)"extension") && (this.persistenceStructureService.hasReference(businessObject.getClass(), referenceObjectName) || this.persistenceStructureService.hasCollection(businessObject.getClass(), referenceObjectName))) {
            this.retrieveReferenceObject(businessObject, referenceObjectName);
        }
    }

    public boolean isLockable(Object object) {
        return this.isPersistable(object.getClass());
    }

    public void verifyVersionNumber(Object dataObject) {
        if (this.isPersistable(dataObject.getClass())) {
            Object pbObject = this.businessObjectService.retrieve(dataObject);
            if (dataObject instanceof Versioned) {
                Long pbObjectVerNbr = KRADUtils.isNull((Object)pbObject) ? null : ((Versioned)pbObject).getVersionNumber();
                Long newObjectVerNbr = ((Versioned)dataObject).getVersionNumber();
                if (pbObjectVerNbr != null && !pbObjectVerNbr.equals(newObjectVerNbr)) {
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.version.mismatch", new String[0]);
                    throw new ValidationException("Version mismatch between the local business object and the database business object");
                }
            }
        }
    }

    public RemotableQuickFinder.Builder createQuickFinder(Class<?> containingClass, String attributeName) {
        return this.createQuickFinderLegacy(containingClass, attributeName);
    }

    protected RemotableQuickFinder.Builder createQuickFinderLegacy(Class<?> containingClass, String attributeName) {
        Object sampleComponent;
        try {
            sampleComponent = containingClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        String lookupClassName = null;
        HashMap<String, String> fieldConversions = new HashMap<String, String>();
        HashMap<String, String> lookupParameters = new HashMap<String, String>();
        DataObjectRelationship relationship = this.getDataObjectRelationship(sampleComponent, containingClass, attributeName, "", true, true, false);
        if (relationship != null) {
            String toField;
            String fromField;
            lookupClassName = relationship.getRelatedClass().getName();
            for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
                fromField = (String)entry.getValue();
                toField = (String)entry.getKey();
                fieldConversions.put(fromField, toField);
            }
            for (Map.Entry entry : relationship.getParentToChildReferences().entrySet()) {
                fromField = (String)entry.getKey();
                toField = (String)entry.getValue();
                if (relationship.getUserVisibleIdentifierKey() != null && !relationship.getUserVisibleIdentifierKey().equals(fromField)) continue;
                lookupParameters.put(fromField, toField);
            }
        } else {
            String titleAttribute = this.dataObjectMetaDataService.getTitleAttribute(containingClass);
            if (StringUtils.equals((String)titleAttribute, (String)attributeName)) {
                lookupClassName = containingClass.getName();
                List<String> pkAttributes = this.dataObjectMetaDataService.listPrimaryKeyFieldNames(containingClass);
                for (String pkAttribute : pkAttributes) {
                    fieldConversions.put(pkAttribute, pkAttribute);
                    if (StringUtils.equals((String)pkAttribute, (String)attributeName)) continue;
                    lookupParameters.put(pkAttribute, pkAttribute);
                }
            }
        }
        if (StringUtils.isNotBlank((String)lookupClassName)) {
            String baseUrl = this.kualiConfigurationService.getPropertyValueAsString("krad.lookup.url");
            RemotableQuickFinder.Builder builder = RemotableQuickFinder.Builder.create((String)baseUrl, (String)lookupClassName);
            builder.setLookupParameters(lookupParameters);
            builder.setFieldConversions(fieldConversions);
            return builder;
        }
        return null;
    }

    public boolean isReferenceUpdatable(Class<?> type, String referenceName) {
        return this.persistenceStructureService.isReferenceUpdatable(type, referenceName);
    }

    public Map<String, Class<?>> listReferenceObjectFields(Class<?> type) {
        return this.coerce(this.persistenceStructureService.listReferenceObjectFields(type));
    }

    public boolean isCollectionUpdatable(Class<?> type, String collectionName) {
        return this.persistenceStructureService.isCollectionUpdatable(type, collectionName);
    }

    public Map<String, Class<?>> listCollectionObjectTypes(Class<?> type) {
        return this.coerce(this.persistenceStructureService.listCollectionObjectTypes(type));
    }

    private Map<String, Class<?>> coerce(Map map) {
        return map;
    }

    public BusinessObject getReferenceIfExists(Object bo, String referenceName) {
        if (!(bo instanceof BusinessObject)) {
            throw new UnsupportedOperationException("getReferenceIfExists only supports BusinessObject in KNS");
        }
        return this.businessObjectService.getReferenceIfExists((BusinessObject)bo, referenceName);
    }

    public boolean allForeignKeyValuesPopulatedForReference(Object bo, String referenceName) {
        if (!(bo instanceof PersistableBusinessObject)) {
            throw new UnsupportedOperationException("getReferenceIfExists only supports PersistableBusinessObject in KNS");
        }
        return this.persistenceService.allForeignKeyValuesPopulatedForReference((PersistableBusinessObject)bo, referenceName);
    }

    public RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName) {
        DataDictionaryEntry entryBase = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(c.getName());
        if (entryBase == null) {
            return null;
        }
        RelationshipDefinition relationship = null;
        List ddRelationships = entryBase.getRelationships();
        int minKeys = Integer.MAX_VALUE;
        block0: for (RelationshipDefinition def : ddRelationships) {
            if (def.getPrimitiveAttributes().size() == 1) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                    relationship = def;
                    minKeys = 1;
                    continue block0;
                }
                continue;
            }
            if (def.getPrimitiveAttributes().size() >= minKeys) continue;
            for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                relationship = def;
                minKeys = def.getPrimitiveAttributes().size();
                continue block0;
            }
        }
        if (relationship == null) {
            for (RelationshipDefinition def : ddRelationships) {
                if (!def.hasIdentifier() || !def.getIdentifier().getSourceName().equals(attributeName)) continue;
                relationship = def;
            }
        }
        return relationship;
    }

    public String getTitleAttribute(Class<?> dataObjectClass) {
        String titleAttribute = null;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    protected DataObjectEntry getDataObjectEntry(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        return this.dataDictionaryService.getDataDictionary().getDataObjectEntry(dataObjectClass.getName());
    }

    public boolean areNotesSupported(Class<?> dataObjectClass) {
        boolean hasNotesSupport = false;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            hasNotesSupport = entry.isBoNotesEnabled();
        }
        return hasNotesSupport;
    }

    protected Map<String, ?> getPrimaryKeyFieldValues(Object dataObject, boolean sortFieldNames) {
        Map<String, ?> keyFieldValues = this.getPrimaryKeyFieldValues(dataObject);
        if (sortFieldNames) {
            return new TreeMap(keyFieldValues);
        }
        return keyFieldValues;
    }

    public String getDataObjectIdentifierString(Object dataObject) {
        String objectId;
        String identifierString = "";
        if (dataObject == null) {
            identifierString = "Null";
            return identifierString;
        }
        Class<?> dataObjectClass = dataObject.getClass();
        if ((PersistableBusinessObject.class.isAssignableFrom(dataObjectClass) || !LegacyUtils.useLegacyForObject((Object)dataObject) && GloballyUnique.class.isAssignableFrom(dataObjectClass)) && StringUtils.isBlank((String)(objectId = (String)ObjectPropertyUtils.getPropertyValue((Object)dataObject, (String)"objectId")))) {
            objectId = UUID.randomUUID().toString();
            ObjectPropertyUtils.setPropertyValue((Object)dataObject, (String)"objectId", (Object)objectId);
        }
        return identifierString;
    }

    public Class<?> getInquiryObjectClassIfNotTitle(Object dataObject, String propertyName) {
        Class<Object> objectClass = ObjectUtils.materializeClassForProxiedObject(dataObject);
        DataObjectRelationship relationship = this.dataObjectMetaDataService.getDataObjectRelationship(dataObject, objectClass, propertyName, "", true, false, true);
        if (relationship != null) {
            return relationship.getRelatedClass();
        }
        return null;
    }

    public Map<String, String> getInquiryParameters(Object dataObject, List<String> keys, String propertyName) {
        HashMap<String, String> inquiryParameters = new HashMap<String, String>();
        Class<Object> objectClass = ObjectUtils.materializeClassForProxiedObject(dataObject);
        DataObjectRelationship relationship = this.dataObjectMetaDataService.getDataObjectRelationship(dataObject, objectClass, propertyName, "", true, false, true);
        for (String keyName : keys) {
            Object keyConversion = keyName;
            if (relationship != null) {
                keyConversion = relationship.getParentAttributeForChildAttribute(keyName);
            } else if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
                String nestedAttributePrefix = KRADUtils.getNestedAttributePrefix((String)propertyName);
                keyConversion = nestedAttributePrefix + "." + keyName;
            }
            inquiryParameters.put((String)keyConversion, keyName);
        }
        return inquiryParameters;
    }

    public boolean hasLocalLookup(Class<?> dataObjectClass) {
        return this.dataObjectMetaDataService.hasLocalLookup(dataObjectClass);
    }

    public boolean hasLocalInquiry(Class<?> dataObjectClass) {
        return this.dataObjectMetaDataService.hasLocalInquiry(dataObjectClass);
    }

    public DataObjectRelationship getDataObjectRelationship(Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        this.getDictionaryRelationship(dataObjectClass, attributeName);
        return this.dataObjectMetaDataService.getDataObjectRelationship(dataObject, dataObjectClass, attributeName, attributePrefix, keysOnly, supportsLookup, supportsInquiry);
    }

    public boolean isPersistable(Class<?> dataObjectClass) {
        return this.persistenceStructureService.isPersistable(dataObjectClass);
    }

    public <T> void setObjectPropertyDeep(Object bo, String propertyName, Class<T> type, T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectUtils.setObjectPropertyDeep(bo, propertyName, type, propertyValue);
    }

    public boolean isNull(Object object) {
        return ObjectUtils.isNull(object);
    }

    public <T> void setObjectProperty(Object bo, String propertyName, Class<T> propertyType, T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectUtils.setObjectProperty(bo, propertyName, propertyType, propertyValue);
    }

    public <T> Class<T> materializeClassForProxiedObject(T object) {
        return ObjectUtils.materializeClassForProxiedObject(object);
    }

    public Object getNestedValue(Object bo, String fieldName) {
        return ObjectUtils.getNestedValue(bo, fieldName);
    }

    public <T> T createNewObjectFromClass(Class<T> clazz) {
        return (T)ObjectUtils.createNewObjectFromClass(clazz);
    }

    public ForeignKeyFieldsPopulationState getForeignKeyFieldsPopulationState(Object dataObject, String referenceName) {
        return this.persistenceStructureService.getForeignKeyFieldsPopulationState((PersistableBusinessObject)dataObject, referenceName);
    }

    public Map<String, String> getForeignKeysForReference(Class<?> clazz, String attributeName) {
        return this.persistenceStructureService.getForeignKeysForReference(clazz, attributeName);
    }

    public boolean hasPrimaryKeyFieldValues(Object dataObject) {
        return this.persistenceStructureService.hasPrimaryKeyFieldValues(dataObject);
    }

    public <T extends Document> T findByDocumentHeaderId(Class<T> documentClass, String id) {
        return this.documentDao.findByDocumentHeaderId(documentClass, id);
    }

    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> documentClass, List<String> ids) {
        return this.documentDao.findByDocumentHeaderIds(documentClass, ids);
    }

    protected void synchronizeEclipseLinkWeavings(Object persistableObject, String propertyName) {
        if (LegacyUtils.isKradDataManaged(persistableObject.getClass())) {
            List<ValueHolderFieldPair> fieldPairs = this.loadValueHolderFieldPairs(persistableObject.getClass());
            for (ValueHolderFieldPair fieldPair : fieldPairs) {
                if (!fieldPair.field.getName().equals(propertyName)) continue;
                fieldPair.synchronizeValueHolder(persistableObject);
            }
        }
    }

    protected void synchronizeEclipseLinkWeavings(Object persistableObject) {
        if (LegacyUtils.isKradDataManaged(persistableObject.getClass())) {
            List<ValueHolderFieldPair> fieldPairs = this.loadValueHolderFieldPairs(persistableObject.getClass());
            for (ValueHolderFieldPair fieldPair : fieldPairs) {
                fieldPair.synchronizeValueHolder(persistableObject);
            }
        }
    }

    private List<ValueHolderFieldPair> loadValueHolderFieldPairs(Class<?> type) {
        if (this.valueHolderFieldCache.get(type) == null) {
            ArrayList<ValueHolderFieldPair> pairs = new ArrayList<ValueHolderFieldPair>();
            this.searchValueHolderFieldPairs(type, pairs);
            this.valueHolderFieldCache.putIfAbsent(type, pairs);
        }
        return (List)this.valueHolderFieldCache.get(type);
    }

    private void searchValueHolderFieldPairs(Class<?> type, List<ValueHolderFieldPair> pairs) {
        if (type.equals(Object.class)) {
            return;
        }
        for (Field valueHolderField : type.getDeclaredFields()) {
            Matcher matcher = VALUE_HOLDER_FIELD_PATTERN.matcher(valueHolderField.getName());
            if (!matcher.matches()) continue;
            valueHolderField.setAccessible(true);
            String fieldName = matcher.group(1);
            Field valueField = FieldUtils.getDeclaredField(type, (String)fieldName, (boolean)true);
            if (valueField == null) continue;
            pairs.add(new ValueHolderFieldPair(valueField, valueHolderField));
        }
        this.searchValueHolderFieldPairs(type.getSuperclass(), pairs);
    }

    @Required
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Required
    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Required
    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    @Required
    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    @Required
    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    @Required
    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @Required
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    @Required
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Required
    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public LookupDao getLookupDao() {
        return this.lookupDao;
    }

    public DocumentDao getDocumentDao() {
        return this.documentDao;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public DataObjectMetaDataService getDataObjectMetaDataService() {
        return this.dataObjectMetaDataService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    private static final class ValueHolderFieldPair {
        final Field field;
        final Field valueHolderField;

        ValueHolderFieldPair(Field field, Field valueHolderField) {
            this.field = field;
            this.valueHolderField = valueHolderField;
        }

        void synchronizeValueHolder(Object object) {
            try {
                ValueHolder valueHolder = (ValueHolder)this.valueHolderField.get(object);
                if (valueHolder != null) {
                    Object value = this.field.get(object);
                    valueHolder.setValue(value);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

