/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.form;

import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.inquiry.Inquirable;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;

@Deprecated
public class InquiryForm
extends KualiForm {
    private static final Logger LOG = LogManager.getLogger(InquiryForm.class);
    private static final long serialVersionUID = 1L;
    private String fieldConversions;
    private List sections;
    private String businessObjectClassName;
    private Map editingMode = new HashMap();
    private String formKey;
    private boolean canExport;
    private List<Note> boNotes;
    private Map<String, String> inquiryPrimaryKeys;
    private Map<String, String> inquiryDecryptedPrimaryKeys;
    private Map<String, Boolean> inactiveRecordDisplay;
    private Inquirable inquirable;

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        this.registerRequiredNonEditableProperty("businessObjectClassName");
        this.registerRequiredNonEditableProperty("methodToCall");
        this.registerRequiredNonEditableProperty("docFormKey");
        this.registerRequiredNonEditableProperty("formKey");
        this.registerRequiredNonEditableProperty("fieldConversions");
        this.registerRequiredNonEditableProperty("backLocation");
    }

    public InquiryForm() {
        this.editingMode.put("viewOnly", "TRUE");
        this.inactiveRecordDisplay = null;
        this.boNotes = new ArrayList<Note>();
    }

    @Override
    public void populate(HttpServletRequest request) {
        this.inquirable = null;
        super.populate(request);
        if (request.getParameter("returnLocation") != null) {
            this.setBackLocation(request.getParameter("returnLocation"));
        }
        if (request.getParameter("docFormKey") != null) {
            this.setFormKey(request.getParameter("docFormKey"));
        }
        if (!"downloadBOAttachment".equals(this.getMethodToCall()) && StringUtils.isBlank((String)this.getFormKey())) {
            this.setFormKey(GlobalVariables.getUserSession().addObjectWithGeneratedKey((Object)this));
        }
        if (!"downloadBOAttachment".equals(this.getMethodToCall())) {
            this.inquirable = this.getInquirable(this.getBusinessObjectClassName());
            boolean passedFromPreviousInquiry = !"start".equals(this.getMethodToCall()) && !"continueWithInquiry".equals(this.getMethodToCall()) && !"downloadCustomBOAttachment".equals(this.getMethodToCall());
            this.inquiryPrimaryKeys = new HashMap<String, String>();
            this.inquiryDecryptedPrimaryKeys = new HashMap<String, String>();
            this.populatePKFieldValues(request, this.getBusinessObjectClassName(), passedFromPreviousInquiry);
            this.populateInactiveRecordsInIntoInquirable(this.inquirable, request);
            this.populateExportCapabilities(request, this.getBusinessObjectClassName());
        }
    }

    protected Inquirable getInquirable(String boClassName) {
        try {
            Class<? extends org.kuali.rice.krad.inquiry.Inquirable> customInquirableClass = null;
            try {
                BusinessObjectEntry entry = (BusinessObjectEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(boClassName);
                customInquirableClass = entry.getInquiryDefinition().getInquirableClass();
            }
            catch (Exception e) {
                LOG.error("Unable to correlate business object class with maintenance document entry", (Throwable)e);
            }
            Inquirable kualiInquirable = KNSServiceLocator.getKualiInquirable();
            if (customInquirableClass != null) {
                Class[] defaultConstructor = new Class[]{};
                Constructor<? extends org.kuali.rice.krad.inquiry.Inquirable> cons = customInquirableClass.getConstructor(defaultConstructor);
                kualiInquirable = (Inquirable)cons.newInstance(new Object[0]);
            }
            kualiInquirable.setBusinessObjectClass(Class.forName(boClassName));
            return kualiInquirable;
        }
        catch (Exception e) {
            LOG.error("Error attempting to retrieve inquirable.", (Throwable)e);
            throw new RuntimeException("Error attempting to retrieve inquirable.", e);
        }
    }

    private List<List<String>> getAltkeys(Class<?> clazz) {
        KualiModuleService kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        ModuleService moduleService = kualiModuleService.getResponsibleModuleService(clazz);
        List altKeys = null;
        if (moduleService != null) {
            altKeys = moduleService.listAlternatePrimaryKeyFieldNames(clazz);
        }
        return altKeys != null ? altKeys : new ArrayList();
    }

    protected void populatePKFieldValues(HttpServletRequest request, String boClassName, boolean passedFromPreviousInquiry) {
        try {
            EncryptionService encryptionService = CoreApiServiceLocator.getEncryptionService();
            DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
            BusinessObjectAuthorizationService businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
            BusinessObjectMetaDataService businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
            Class<?> businessObjectClass = Class.forName(boClassName);
            List boPKeys = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(businessObjectClass);
            List<List<String>> altKeys = this.getAltkeys(businessObjectClass);
            altKeys.add(boPKeys);
            boolean bFound = false;
            for (List<String> boKeys : altKeys) {
                if (bFound) break;
                int keyCount = boKeys.size();
                int foundCount = 0;
                for (String boKey : boKeys) {
                    Object pkParamName = boKey;
                    if (passedFromPreviousInquiry) {
                        pkParamName = "previousPkValue_" + (String)pkParamName;
                    }
                    if (request.getParameter((String)pkParamName) == null) continue;
                    ++foundCount;
                    String parameter = request.getParameter((String)pkParamName);
                    Boolean forceUppercase = Boolean.FALSE;
                    try {
                        forceUppercase = dataDictionaryService.getAttributeForceUppercase(businessObjectClass, boKey);
                    }
                    catch (UnknownBusinessClassAttributeException ex) {
                        LOG.warn("BO class " + this.businessObjectClassName + " property " + boKey + " should probably have a DD definition.", (Throwable)ex);
                    }
                    String parameterCopy = parameter;
                    if (forceUppercase.booleanValue()) {
                        parameter = parameter.toUpperCase();
                    }
                    this.inquiryPrimaryKeys.put(boKey, parameter);
                    if (businessObjectAuthorizationService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(businessObjectClass, boKey)) {
                        try {
                            if (!CoreApiServiceLocator.getEncryptionService().isEnabled()) continue;
                            this.inquiryDecryptedPrimaryKeys.put(boKey, encryptionService.decrypt(parameterCopy));
                            continue;
                        }
                        catch (GeneralSecurityException e) {
                            LOG.error("BO class " + this.businessObjectClassName + " property " + boKey + " should have been encrypted, but there was a problem decrypting it.");
                            throw e;
                        }
                    }
                    this.inquiryDecryptedPrimaryKeys.put(boKey, parameter);
                }
                if (foundCount != keyCount) continue;
                bFound = true;
            }
            if (!bFound) {
                LOG.error("All keys not given to lookup for bo class name " + businessObjectClass.getName());
                throw new RuntimeException("All keys not given to lookup for bo class name " + businessObjectClass.getName());
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Can't instantiate class: " + boClassName, (Throwable)e);
            throw new RuntimeException("Can't instantiate class: " + boClassName, e);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Can't decrypt value", (Throwable)e);
            throw new RuntimeException("Can't decrypt value", e);
        }
    }

    protected void populateExportCapabilities(HttpServletRequest request, String boClassName) {
        this.setCanExport(false);
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(boClassName);
        Class exporterClass = businessObjectEntry.getExporterClass();
        if (exporterClass != null) {
            try {
                Exporter exporter = (Exporter)exporterClass.newInstance();
                if (exporter.getSupportedFormats(businessObjectEntry.getBusinessObjectClass()).contains("xml")) {
                    this.setCanExport(true);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to locate or create exporter class: " + String.valueOf(exporterClass), (Throwable)e);
                throw new RuntimeException("Failed to locate or create exporter class: " + String.valueOf(exporterClass), e);
            }
        }
    }

    public String getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(String fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public List getSections() {
        return this.sections;
    }

    public void setSections(List sections) {
        this.sections = sections;
    }

    public String getBusinessObjectClassName() {
        return this.businessObjectClassName;
    }

    public void setBusinessObjectClassName(String businessObjectClassName) {
        this.businessObjectClassName = businessObjectClassName;
    }

    public Map getEditingMode() {
        return this.editingMode;
    }

    public Map<String, String> getInquiryPrimaryKeys() {
        return this.inquiryPrimaryKeys;
    }

    public Map<String, String> retrieveInquiryDecryptedPrimaryKeys() {
        return this.inquiryDecryptedPrimaryKeys;
    }

    public void setInquiryPrimaryKeys(Map<String, String> inquiryPrimaryKeys) {
        this.inquiryPrimaryKeys = inquiryPrimaryKeys;
    }

    public Map<String, Boolean> getInactiveRecordDisplay() {
        return this.getInquirable().getInactiveRecordDisplay();
    }

    public Inquirable getInquirable() {
        return this.inquirable;
    }

    protected void populateInactiveRecordsInIntoInquirable(Inquirable inquirable, HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!paramName.startsWith("inactiveRecordDisplay_")) continue;
            String collectionName = StringUtils.substringAfter((String)paramName, (String)"inactiveRecordDisplay_");
            Boolean showInactive = Boolean.parseBoolean(request.getParameter(paramName));
            inquirable.setShowInactiveRecords(collectionName, showInactive);
        }
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public boolean isCanExport() {
        return this.canExport;
    }

    public void setCanExport(boolean canExport) {
        this.canExport = canExport;
    }

    public List<Note> getBoNotes() {
        return this.boNotes;
    }

    public void setBoNotes(List<Note> boNotes) {
        this.boNotes = boNotes;
    }
}

