/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao.impl;

import java.sql.Timestamp;

import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.bo.SessionDocument;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.dao.SessionDocumentDao;
import org.kuali.rice.krad.util.KRADPropertyConstants;
import org.springframework.dao.DataAccessException;

/**
 * This class is the OJB implementation of the DocumentDao interface.
 */
public class SessionDocumentDaoOjb extends PlatformAwareDaoBaseOjb implements SessionDocumentDao{
    private BusinessObjectDao businessObjectDao;
    

    public SessionDocumentDaoOjb() {
        super();
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see SessionDocumentDao#purgeAllSessionDocuments(java.sql.Timestamp)
     */
    @Override
    public void purgeAllSessionDocuments(Timestamp expirationDate)throws DataAccessException {
    	Criteria criteria = new Criteria();
		criteria.addLessThan(KRADPropertyConstants.LAST_UPDATED_DATE, expirationDate);
		 getPersistenceBrokerTemplate().deleteByQuery(QueryFactory.newQuery(SessionDocument.class, criteria));
		 //getPersistenceBrokerTemplate().clearCache();
	        
    }

 
}
