/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao;

import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.util.LegacyDataFramework;

import java.util.List;

/**
 * This is the data access interface for Document objects.
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 */
@Deprecated
@LegacyDataFramework
public interface DocumentDao {

	public <T extends Document> T save(T document);

	public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id);

	public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList);

	public BusinessObjectDao getBusinessObjectDao();

	public DocumentAdHocService getDocumentAdHocService();

}
