/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.kns.bo.GlobalBusinessObject;
import org.kuali.rice.krad.bo.MultiDocumentAttachment;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectSerializerService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.KRADUtils;

import javax.persistence.Transient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Use {@link org.kuali.rice.krad.maintenance.MaintenanceDocumentBase}.
 */
@Deprecated
public class MaintenanceDocumentBase extends org.kuali.rice.krad.maintenance.MaintenanceDocumentBase implements MaintenanceDocument {
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(MaintenanceDocumentBase.class);
    public static final String ATTACHMENT = "attachment";
    public static final String ATTACHMENTS = "attachments";

    @Transient
    protected transient FormFile fileAttachment;

    public MaintenanceDocumentBase() {
        super();
    }

    public MaintenanceDocumentBase(String documentTypeName) {
        super(documentTypeName);
    }

    @Override
    public Object getDocumentBusinessObject() {
        return super.getDocumentDataObject();
    }

    /**
     * Checks old maintainable bo has key values
     */
    @Override
    public boolean isOldBusinessObjectInDocument() {
        final boolean isOldBusinessObjectInExistence;
        if (getOldMaintainableObject() == null || getOldMaintainableObject().getBusinessObject() == null) {
            isOldBusinessObjectInExistence = false;
        } else {
            isOldBusinessObjectInExistence = getOldMaintainableObject().isOldBusinessObjectInDocument();
        }
        return isOldBusinessObjectInExistence;
    }

    @Override
    public Maintainable getNewMaintainableObject() {
        return (Maintainable) newMaintainableObject;
    }

    @Override
    public Maintainable getOldMaintainableObject() {
        return (Maintainable) oldMaintainableObject;
    }

    public FormFile getFileAttachment() {
        return this.fileAttachment;
    }

    public void setFileAttachment(FormFile fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    /**
     * The attachment BO is proxied in OJB.  For some reason when an attachment does not yet exist,
     * refreshReferenceObject is not returning null and the proxy cannot be materialized. So, this method exists to
     * properly handle the proxied attachment BO.  This is a hack and should be removed post JPA migration.
     */
    @Override
    protected void refreshAttachment() {
        if (KRADUtils.isNull(attachment)) {
            this.refreshReferenceObject(ATTACHMENT);
            final boolean isProxy = attachment != null && ProxyHelper.isProxy(attachment);
            if (isProxy && ProxyHelper.getRealObject(attachment) == null) {
                attachment = null;
            }
        }
    }

    @Override
    protected void refreshAttachmentList() {
        if (KRADUtils.isNull(attachments)) {
            this.refreshReferenceObject(ATTACHMENTS);
            final boolean isProxy = attachments != null && ProxyHelper.isProxy(attachments);
            if (isProxy && ProxyHelper.getRealObject(attachments) == null) {
                attachments = null;
            }
        }
    }

    @Override
    public void populateDocumentAttachment() {
        refreshAttachment();

        if (fileAttachment != null && StringUtils.isNotEmpty(fileAttachment.getFileName()) && isAttachmentPropertyNameRootLevel()) {
            //Populate DocumentAttachment BO
            if (attachment == null) {
                attachment = new DocumentAttachment();
            }

            byte[] fileContents;
            try {
                fileContents = fileAttachment.getFileData();
                if (fileContents.length > 0) {
                    attachment.setFileName(fileAttachment.getFileName());
                    attachment.setContentType(fileAttachment.getContentType());
                    attachment.setAttachmentContent(fileAttachment.getFileData());
                    attachment.setObjectId(UUID.randomUUID().toString());
                    PersistableAttachment boAttachment = (PersistableAttachment) newMaintainableObject.getDataObject();
                    boAttachment.setAttachmentContent(null);
                    attachment.setDocumentNumber(getDocumentNumber());
                }
            } catch (IOException e) {
                LOG.error("Error while populating the Document Attachment", e);
                throw new RuntimeException("Could not populate DocumentAttachment object", e);
            }
        } else {
            //fileAttachment isn't filled, populate from bo if it exists
            PersistableAttachment boAttachment = (PersistableAttachment) newMaintainableObject.getDataObject();
            if (attachment == null
                    && boAttachment != null
                    && boAttachment.getAttachmentContent() != null) {
                DocumentAttachment newAttachment = new DocumentAttachment();
                newAttachment.setDocumentNumber(getDocumentNumber());
                newAttachment.setAttachmentContent(boAttachment.getAttachmentContent());
                newAttachment.setContentType(boAttachment.getContentType());
                newAttachment.setFileName(boAttachment.getFileName());

                //due to a OJB to JPA conversion bug, set some fields that
                //would normally get set by pre save hooks
                if (newAttachment.getObjectId() == null) {
                    newAttachment.setObjectId(UUID.randomUUID().toString());
                }
                if(newAttachment.getVersionNumber() == null) {
                    newAttachment.setVersionNumber(1L);
                }

                //null out boAttachment file, will be copied back before final save.
                boAttachment.setAttachmentContent(null);
                attachment = newAttachment;
            }
        }
    }

    @Override
    public void populateAttachmentForBO() {
        refreshAttachment();

        final Object dataObject = newMaintainableObject.getDataObject();

    	if (StringUtils.isNotBlank(getAttachmentPropertyName())) {
    		if(dataObject instanceof PersistableAttachment) {
    		    try {
                    final PersistableAttachment boAttachment;
    		        final String attachmentFormPropertyName;
                    if (isAttachmentPropertyNameRootLevel()) {
                        attachmentFormPropertyName = getAttachmentPropertyName();
                        boAttachment = (PersistableAttachment) dataObject;
                    } else {
                        boAttachment = null;
                        attachmentFormPropertyName = null;
                    }

                    if (boAttachment != null && attachmentFormPropertyName != null) {
                        final FormFile attachmentFromBusinessObject = (FormFile) PropertyUtils.getNestedProperty(boAttachment, attachmentFormPropertyName);
                        if (attachmentFromBusinessObject != null) {
                            boAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                            boAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                        }
                    }
    		   } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
    				LOG.error("Not able to get the attachment " + e.getMessage(), e);
    				throw new RuntimeException("Not able to get the attachment " + e.getMessage(), e);
    		   }
    	  }
      }

      if((dataObject instanceof PersistableAttachment) && (((PersistableAttachment)dataObject).getFileName() == null) && (attachment != null)) {
          final PersistableAttachment boAttachment = (PersistableAttachment) dataObject;
          if (attachment.getFileName() != null) {
              boAttachment.setAttachmentContent(null);
              boAttachment.setFileName(attachment.getFileName());
              boAttachment.setContentType(attachment.getContentType());
          }
       }
    }

    @Override
    public void populateAttachmentBeforeSave() {
        PersistableAttachment boAttachment = (PersistableAttachment) newMaintainableObject.getDataObject();
        if (attachment != null
                && attachment.getAttachmentContent() != null) {
            boAttachment.setAttachmentContent(attachment.getAttachmentContent());
        } else {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(null);
            boAttachment.setContentType(null);
        }
    }

    @Override
    public void populateBoAttachmentListBeforeSave() {

        final PersistableAttachmentList<PersistableAttachment> boAttachments = (PersistableAttachmentList<PersistableAttachment>) newMaintainableObject.getDataObject();
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }

        final Map<String, MultiDocumentAttachment> files = new HashMap<>();
        for (MultiDocumentAttachment multiAttach : attachments) {
            String key = multiAttach.getFileName() + "|" + multiAttach.getContentType();
            files.put(key, multiAttach);
        }


        //want to just copy over file if possible, as there can be other fields that are not on PersistableAttachment
        //these arrays should be somewhat synched by the other populate methods
        if (CollectionUtils.isNotEmpty(boAttachments.getAttachments())) {
            for (PersistableAttachment attach : boAttachments.getAttachments()) {
                //try to get a new instance of the correct object...
                final String key = attach.getFileName() + "|" + attach.getContentType();
                if (files.containsKey(key)) {
                    attach.setAttachmentContent(files.get(key).getAttachmentContent());
                    files.remove(key);
                }
            }
        }
    }

    @Override
    public void populateAttachmentListForBO() {
        refreshAttachmentList();

        final Object dataObject = newMaintainableObject.getDataObject();

        if (StringUtils.isNotBlank(getAttachmentListPropertyName())) {
            if (dataObject instanceof PersistableAttachmentList) {
                try {
                    final PersistableAttachmentList<? extends PersistableAttachment> boAttachmentList;
                    final String attachmentListFormPropertyName;
                    if (isAttachmentListPropertyNameRootLevel()) {
                        attachmentListFormPropertyName = getAttachmentListPropertyName();
                        boAttachmentList = (PersistableAttachmentList<? extends PersistableAttachment>) dataObject;
                    } else {
                        boAttachmentList = null;
                        attachmentListFormPropertyName = null;
                    }

                    if (boAttachmentList != null && attachmentListFormPropertyName != null) {
                        for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                            final FormFile attachmentFromBusinessObject = (FormFile) PropertyUtils.getNestedProperty(persistableAttachment, attachmentListFormPropertyName);
                            if (attachmentFromBusinessObject != null && StringUtils.isNotBlank(attachmentFromBusinessObject.getFileName())) {
                                persistableAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                                persistableAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                            }
                        }

                    }
                } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
                    LOG.error("Not able to get the attachment list" + e.getMessage(), e);
                    throw new RuntimeException("Not able to get the attachment list" + e.getMessage(), e);
                }
            }
        }

        if(dataObject instanceof PersistableAttachmentList && CollectionUtils.isNotEmpty(((PersistableAttachmentList<? extends PersistableAttachment>) dataObject).getAttachments())) {
            final List<? extends PersistableAttachment> att = ((PersistableAttachmentList<? extends PersistableAttachment>) dataObject).getAttachments();

            if (attachments == null) {
                attachments = new ArrayList<>();
            }
            att.forEach(a -> {
                final MultiDocumentAttachment multiDocumentAttachment = new MultiDocumentAttachment();
                multiDocumentAttachment.setContentType(a.getContentType());
                multiDocumentAttachment.setFileName(a.getFileName());
            });
        }
    }


    @Override
    public void populateDocumentAttachmentList() {
        refreshAttachmentList();

        final Object dataObject = newMaintainableObject.getDataObject();

        if (dataObject instanceof PersistableAttachmentList && CollectionUtils.isNotEmpty(((PersistableAttachmentList<? extends PersistableAttachment>) dataObject).getAttachments()) && isAttachmentListPropertyNameRootLevel()) {

            try {

                //build map for comparison
                final Map<String, MultiDocumentAttachment> files = new HashMap<>();
                for (MultiDocumentAttachment multiAttach : attachments) {
                    final String key = multiAttach.getFileName() + "|" + multiAttach.getContentType();
                    files.put(key, multiAttach);
                }

                //Populate DocumentAttachment BO
                attachments = new ArrayList<>();

                final PersistableAttachmentList<PersistableAttachment> boAttachmentList = (PersistableAttachmentList<PersistableAttachment>) dataObject;

                for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                    final String existingKey = persistableAttachment.getFileName() + "|" + persistableAttachment.getContentType();

                    FormFile attachmentFromBusinessObject = (FormFile) PropertyUtils.getNestedProperty(persistableAttachment, getAttachmentListPropertyName());
                    if (attachmentFromBusinessObject != null) {
                        final String newKey = attachmentFromBusinessObject.getFileName() + "|" + attachmentFromBusinessObject.getContentType();
                        if (files.containsKey(newKey)) {
                            final MultiDocumentAttachment attach = files.get(newKey);
                            attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                            attachments.add(attach);
                            files.remove(newKey);
                        } else {
                            final MultiDocumentAttachment attach = new MultiDocumentAttachment();
                            attach.setFileName(attachmentFromBusinessObject.getFileName());
                            attach.setContentType(attachmentFromBusinessObject.getContentType());
                            attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                            attach.setDocumentNumber(getDocumentNumber());
                            attach.setObjectId(UUID.randomUUID().toString());
                            attachments.add(attach);
                        }
                    } else if (files.containsKey(existingKey)) {
                        attachments.add(files.get(existingKey));
                        files.remove(existingKey);
                    } else {
                        if (persistableAttachment.getFileName() != null && persistableAttachment.getAttachmentContent() != null) {
                            final MultiDocumentAttachment attach = new MultiDocumentAttachment();
                            attach.setFileName(persistableAttachment.getFileName());
                            attach.setContentType(persistableAttachment.getContentType());
                            attach.setAttachmentContent(persistableAttachment.getAttachmentContent());
                            attach.setDocumentNumber(getDocumentNumber());
                            attach.setObjectId(UUID.randomUUID().toString());
                            //set Bo's content to null
                            persistableAttachment.setAttachmentContent(null);
                            attachments.add(attach);
                        }
                    }
                }
            } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException | IOException e) {
                LOG.error("Not able to get the attachment list" + e.getMessage(), e);
                throw new RuntimeException("Not able to get the attachment list" + e.getMessage(), e);
            }

        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected BusinessObjectSerializerService getBusinessObjectSerializerService() {
        return KRADServiceLocator.getBusinessObjectSerializerService();
    }

    /**
     * this needs to happen after the document itself is saved, to preserve consistency of the ver_nbr and in the case
     * of initial save, because this can't be saved until the document is saved initially
     *
     * @see org.kuali.rice.krad.document.DocumentBase#postProcessSave(org.kuali.rice.krad.rules.rule.event.DocumentEvent)
     */
    @Override
    public void postProcessSave(DocumentEvent event) {
        Object bo = getNewMaintainableObject().getDataObject();
        if (bo instanceof GlobalBusinessObject) {
            bo = KRADServiceLocatorWeb.getLegacyDataAdapter().save(bo);
            // KRAD/JPA - have to change the handle to object to that just saved
            getNewMaintainableObject().setDataObject(bo);
        }

        //currently only global documents could change the list of what they're affecting during routing,
        //so could restrict this to only happening with them, but who knows if that will change, so safest
        //to always do the delete and re-add...seems a bit inefficient though if nothing has changed, which is
        //most of the time...could also try to only add/update/delete what's changed, but this is easier
        if (!(event instanceof SaveDocumentEvent)) { //don't lock until they route
            getMaintenanceDocumentService().deleteLocks(MaintenanceDocumentBase.this.getDocumentNumber());
            getMaintenanceDocumentService().storeLocks(MaintenanceDocumentBase.this.getNewMaintainableObject().generateMaintenanceLocks());
        }
    }


}
