/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.util.KRADConstants;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Base class for all TransactionalDocumentAuthorizers.
 *
 * @deprecated Use {@link org.kuali.rice.krad.document.TransactionalDocumentAuthorizerBase}.
 */
@Deprecated
public class TransactionalDocumentAuthorizerBase extends DocumentAuthorizerBase
		implements TransactionalDocumentAuthorizer {
	//KULRICE-12362: Removed final modifier at request of KFS
    @Override
    public Set<String> getEditModes(Document document, Person user,
                                    Set<String> editModes) {
		Set<String> unauthorizedEditModes = new HashSet<String>();
		for (String editMode : editModes) {
			Map<String, String> additionalPermissionDetails = new HashMap<String, String>();
			additionalPermissionDetails.put(KimConstants.AttributeConstants.EDIT_MODE, editMode);
			if (permissionExistsByTemplate(
					document,
					KRADConstants.KNS_NAMESPACE,
					KimConstants.PermissionTemplateNames.USE_TRANSACTIONAL_DOCUMENT,
					additionalPermissionDetails)
					&& !isAuthorizedByTemplate(
							document,
							KRADConstants.KNS_NAMESPACE,
							KimConstants.PermissionTemplateNames.USE_TRANSACTIONAL_DOCUMENT,
							user.getPrincipalId(), additionalPermissionDetails,
							null)) {
				unauthorizedEditModes.add(editMode);
			}
		}
		editModes.removeAll(unauthorizedEditModes);
		return editModes;
	}

}
