/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;

import java.util.List;
import java.util.Map;

/**
 * Defines methods that a BusinessObjectService must provide
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 */
@Deprecated
@LegacyDataFramework
public interface BusinessObjectService {

    /**
     * Saves the passed in object via the persistence layer.
     * 
     * This will throw an IllegalArgumentException (runtime exception) if the object passed in is not a descendent of
     * BusinessObject.
     * 
     * @param bo A BusinessObject instance or descendent that you wish to be stored.
     */
    <T extends PersistableBusinessObject> T save(T bo);

    /**
     * Saves the businessObjects on the list via the persistence layer.
     * 
     * This will throw an IllegalArgumentException (runtime exception) if any of the objects passed in is not a descendent of
     * BusinessObject.
     * 
     * @param businessObjects A List&lt;PersistableBusinessObject&gt; of objects to persist.
     */
    <T extends PersistableBusinessObject> List<T> save(List<T> businessObjects);

    /**
     * Links up any contained objects, and then Saves the passed in object via the persistence layer.
     * 
     * This will throw an IllegalArgumentException (runtime exception) if the object passed in is not a descendent of
     * BusinessObject.
     * 
     * @param bo A BusinessObject instance or descendent that you wish to be stored.
     */
    <T extends PersistableBusinessObject> T linkAndSave(T bo);

    /**
     * Links up any contained objects, and Saves the businessObjects on the list via the persistence layer.
     * 
     * This will throw an IllegalArgumentException (runtime exception) if any of the objects passed in is not a descendent of
     * BusinessObject.
     * 
     * @param businessObjects A List&lt;BusinessObject&gt; of objects to persist.
     * 
     */
    <T extends PersistableBusinessObject> List<T> linkAndSave(List<T> businessObjects);

    /**
     * Retrieves an object instance identified by its primary key. For composite keys, use {@link #findByPrimaryKey(Class, Map)}
     */
    <T extends PersistableBusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey);
    
    /**
     * Retrieves an object instance identified by its primary keys and values. This can be done by constructing a map where the key
     * to the map entry is the primary key attribute and the value of the entry being the primary key value. For composite keys,
     * pass in each primaryKey attribute and its value as a map entry.
     */
    <T extends PersistableBusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys);

    /**
     * Retrieves an object instance identified by the class of the given object and the object's primary key values.
     */
    Object retrieve(Object object);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     */
    <T extends PersistableBusinessObject> List<T> findAll(Class<T> clazz);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     *
     */
    <T extends PersistableBusinessObject> List<T> findAllOrderBy( Class<T> clazz, String sortField, boolean sortAscending );
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAllOrderBy( Class<T> clazz, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name and its expected value.
     *
     */
    <T extends PersistableBusinessObject> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest);

    /**
     * This method retrieves a count of the business objects populated with data which match the criteria in the given Map.
     * @return number of businessObjects of the given class whose fields match the values in the given expected-value Map
     */
    <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> fieldValues);

    /**
     * This method retrieves a count of the business objects populated with data which match both the positive criteria 
     * and the negative criteria in the given Map.
     *
     * @return number of businessObjects of the given class whose fields match the values in the given expected-value Maps
     */
    <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name and its expected value. Performs an order by on sort field.
     */
    <T extends PersistableBusinessObject> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest);

    /**
     * Deletes a business object from the database.
     */
    void delete(Object bo);

    /**
     * Deletes each business object in the given List.
     * 
     */
    <T extends PersistableBusinessObject> void delete(List<T> boList);

    /**
     * Deletes the object(s) matching the given field values
     *
     */
    <T extends PersistableBusinessObject> void deleteMatching(Class<T> clazz, Map<String, ?> fieldValues);

    /**
     * 
     * This method attempts to retrieve the reference from a BO if it exists.
     * 
     * @param bo - populated BusinessObject instance that includes the referenceName property
     * @param referenceName - name of the member/property to load
     * @return A populated object from the DB, if it exists
     * 
     */
    BusinessObject getReferenceIfExists(BusinessObject bo, String referenceName);

    /**
     * 
     * Updates all KualiUser or Person objects contained within this BO, based on the UserID as the authoritative key. The
     * appropriate foreign-key field in the BO itself is also updated.
     * 
     * This allows UserIDs to be entered on forms, and the back-end will link up correctly based on this non-key field.
     * 
     * @param bo The populated BO (or descendent) instance to be linked & updated
     * 
     */
    void linkUserFields(Object bo);

    /**
     * Merges the given business object, but tells the ORM that the object is to be treated as Read Only,
     * and even if it has changes, it will not be persisted to the database
     *
     * @param bo the business object to managed
     * @return the managed copied of the business object
     */
    <T extends PersistableBusinessObject> T manageReadOnly(T bo);
}

