/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.persistence.indirection.ValueHolder;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.uif.UifPropertyPaths;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.*;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class KNSLegacyDataAdapterImpl implements LegacyDataAdapter {
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(
            KNSLegacyDataAdapterImpl.class);

    private static final Pattern VALUE_HOLDER_FIELD_PATTERN = Pattern.compile("^_persistence_(.*)_vh$");

    private final ConcurrentMap<Class<?>, List<ValueHolderFieldPair>> valueHolderFieldCache =
            new ConcurrentHashMap<>(8, 0.9f, 1);

    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private LookupDao lookupDao;
    private DocumentDao documentDao;
    private PersistenceStructureService persistenceStructureService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private ConfigurationService kualiConfigurationService;
    private KualiModuleService kualiModuleService;
    private DataDictionaryService dataDictionaryService;

    @Override
    public <T> T save(T dataObject) {
        if (dataObject instanceof Collection) {
            Collection<Object> newList = new ArrayList<>(((Collection) dataObject).size());
            for (Object obj : (Collection<?>) dataObject) {
                newList.add(save(obj));
            }
            return (T) newList;
        } else {
           return (T) businessObjectService.save((PersistableBusinessObject) dataObject);
        }
    }

    @Override
    public void flush(Class<?> type) {}

    @Override
    public <T> T linkAndSave(T dataObject) {
       return (T) businessObjectService.linkAndSave((PersistableBusinessObject) dataObject);
    }

    @Override
    public <T> T saveDocument(T document) {
        return (T) documentDao.save((Document) document);
    }

    @Override
    public <T> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        return (T) businessObjectService.findByPrimaryKey((Class<PersistableBusinessObject>) clazz, primaryKeys);
    }

    @Override
    public <T> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return (T) businessObjectService.findBySinglePrimaryKey((Class<PersistableBusinessObject>) clazz, primaryKey);
    }

    @Override
    public void delete(Object dataObject) {
        if (dataObject instanceof Collection) {
            for (Object dobj : (Collection) dataObject) {
                delete(dobj);
            }
        } else {
            businessObjectService.delete(dataObject);
        }
    }

    @Override
    public <T> void deleteMatching(Class<T> type, Map<String, ?> fieldValues) {
        businessObjectService.deleteMatching((Class<PersistableBusinessObject>) type, fieldValues);
    }

    @Override
    public <T> T retrieve(T dataObject) {
        return (T) businessObjectService.retrieve(dataObject);
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz) {
        // just find all objects of given type without any attribute criteria
        return findMatching(clazz, Collections.emptyMap());
    }

    @Override
    public <T> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest) {
        return findMatching(clazz, Collections.emptyMap(), pagingRequest);
    }

    @Override
    public <T> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        return (List<T>) businessObjectService.findMatching((Class<PersistableBusinessObject>) clazz, fieldValues);
    }

    @Override
    public <T> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest) {
        return (QueryPagingResults<T>) businessObjectService.findMatching((Class<PersistableBusinessObject>) clazz, fieldValues, pagingRequest);
    }

    @Override
    public <T> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField,
            boolean sortAscending) {
        return (List<T>) businessObjectService.findMatchingOrderBy((Class<PersistableBusinessObject>) clazz, fieldValues, sortField, sortAscending);
    }

    @Override
    public <T> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest) {
        return (QueryPagingResults<T>) businessObjectService.findMatchingOrderBy((Class<PersistableBusinessObject>) clazz, fieldValues, sortField, sortAscending, pagingRequest);
    }

    @Override
    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject) {
        return persistenceService.getPrimaryKeyFieldValues(dataObject);
    }

    @Override
    public void retrieveNonKeyFields(Object persistableObject) {
        persistenceService.retrieveNonKeyFields(persistableObject);
        synchronizeEclipseLinkWeavings(persistableObject);
    }

    @Override
    public void retrieveReferenceObject(Object persistableObject, String referenceObjectName) {
        persistenceService.retrieveReferenceObject(persistableObject, referenceObjectName);
        synchronizeEclipseLinkWeavings(persistableObject, referenceObjectName);
    }

    @Override
    public void refreshAllNonUpdatingReferences(Object persistableObject) {
        persistenceService.refreshAllNonUpdatingReferences((PersistableBusinessObject) persistableObject);
        synchronizeEclipseLinkWeavings(persistableObject);
    }

    @Override
    public boolean isProxied(Object object) {
    	if ((!(object instanceof BusinessObject) && !(object instanceof PersistableBusinessObjectBaseAdapter))) {
    		return false;
    	}
		return persistenceService.isProxied(object);
    }

    @Override
    public Object resolveProxy(Object o) {
        return persistenceService.resolveProxy(o);
    }

    @Override
    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties,
            boolean unbounded, boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
            return lookupDao.findCollectionBySearchHelper(dataObjectClass, formProperties, unbounded,
                    allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    @Override
    public <T> Collection<T> findCollectionBySearchHelper(Class<T> dataObjectClass, Map<String, String> formProperties,
            List<String> wildcardAsLiteralPropertyNames, boolean unbounded,
            boolean allPrimaryKeyValuesPresentAndNotWildcard, Integer searchResultsLimit) {
        return lookupDao.findCollectionBySearchHelper(dataObjectClass, formProperties, unbounded,
                allPrimaryKeyValuesPresentAndNotWildcard, searchResultsLimit);
    }

    @Override
    public <T> T findObjectBySearch(Class<T> type, Map<String, String> formProps) {
        return lookupDao.findObjectByMap(type, formProps);
    }

    /**
     * Returns whether all primary key values are specified in the lookup  map and do not contain any wildcards
     *
     * @param boClass the bo class to lookup
     * @param formProps the incoming form/lookup properties
     * @return whether all primary key values are specified in the lookup  map and do not contain any wildcards
     */
    @Override
    public boolean allPrimaryKeyValuesPresentAndNotWildcard(Class<?> boClass, Map<String, String> formProps) {
        List<String> pkFields = listPrimaryKeyFieldNames(boClass);
        Iterator<String> pkIter = pkFields.iterator();
        boolean returnVal = true;
        while (returnVal && pkIter.hasNext()) {
            String pkName = pkIter.next();
            String pkValue = formProps.get(pkName);

            if (StringUtils.isBlank(pkValue)) {
                returnVal = false;
            } else {
                for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                    if (pkValue.contains(op.op())) {
                        returnVal = false;
                        break;
                    }
                }
            }
        }
        return returnVal;
    }

	@Override
    public List<String> listPrimaryKeyFieldNames(Class<?> type) {
        List<String> keys = new ArrayList<>();
        if ( type == null ) {
        	return keys;
        }
        if (isPersistable(type)) {
            keys = persistenceStructureService.listPrimaryKeyFieldNames(type);
        } else {
            ModuleService responsibleModuleService = kualiModuleService.getResponsibleModuleService(type);
            if (responsibleModuleService != null && responsibleModuleService.isExternalizable(type)) {
                keys = responsibleModuleService.listPrimaryKeyFieldNames(type);
            } else {
                // check the Data Dictionary for PK's of non PBO/EBO
            	DataObjectEntry dataObjectEntry = dataDictionaryService.getDataDictionary().getDataObjectEntry(type.getName());
            	if ( dataObjectEntry != null ) {
	                List<String> pks = dataObjectEntry.getPrimaryKeys();
	                if (pks != null ) {
	                    keys = pks;
	                }
            	} else {
            		LOG.warn( "Unable to retrieve data object entry for non-persistable KNS-managed class: " + type.getName() );
            	}
            }
        }
        return keys;
    }

    @Override
    public Class<?> determineCollectionObjectType(Class<?> containingType, String collectionPropertyName) {
        final Class<?> collectionObjectType;
        if (isPersistable(containingType)) {
            Map<String, Class> collectionClasses = persistenceStructureService.listCollectionObjectTypes(containingType);
            collectionObjectType = collectionClasses.get(collectionPropertyName);
        } else {
            throw new RuntimeException(
                    "Can't determine the Class of Collection elements because persistenceStructureService.isPersistable("
                            + containingType.getName()
                            + ") returns false.");
        }
        return collectionObjectType;

    }

    @Override
    public boolean hasReference(Class<?> boClass, String referenceName) {
        return persistenceStructureService.hasReference(boClass, referenceName);
    }

    @Override
    public boolean hasCollection(Class<?> boClass, String collectionName) {
        return persistenceStructureService.hasCollection(boClass, collectionName);
    }

    @Override
    public boolean isExtensionAttribute(Class<?> boClass, String attributePropertyName, Class<?> propertyType) {
        return propertyType.equals(PersistableBusinessObjectExtension.class);
    }

    @Override
    public Class<?> getExtensionAttributeClass(Class<?> boClass, String attributePropertyName) {
        return persistenceStructureService.getBusinessObjectAttributeClass((Class<? extends PersistableBusinessObject>)boClass, attributePropertyName);
    }


    @Override
    public Map<String, ?> getPrimaryKeyFieldValuesDOMDS(Object dataObject) {
        return dataObjectMetaDataService.getPrimaryKeyFieldValues(dataObject);
    }

    @Override
    public boolean equalsByPrimaryKeys(Object do1, Object do2) {
        return dataObjectMetaDataService.equalsByPrimaryKeys(do1, do2);
    }

    @Override
    public void materializeAllSubObjects(Object object) {
        ObjectUtils.materializeAllSubObjects((PersistableBusinessObject) object);
    }

    @Override
    public Class<?> getPropertyType(Object object, String propertyName) {
        return ObjectUtils.getPropertyType(object, propertyName, persistenceStructureService);
    }

    @Override
    public Object getExtension(
            Class<?> businessObjectClass) throws InstantiationException, IllegalAccessException {
        Class<? extends PersistableBusinessObjectExtension> extensionClass =
                persistenceStructureService.getBusinessObjectAttributeClass((Class<? extends PersistableBusinessObject>) businessObjectClass, "extension");
        if (extensionClass != null) {
            return extensionClass.newInstance();
        }
        return null;
    }

    @Override
    public void refreshReferenceObject(Object businessObject, String referenceObjectName) {
        if (StringUtils.isNotBlank(referenceObjectName) && !StringUtils.equals(referenceObjectName, "extension")) {
            if (persistenceStructureService.hasReference(businessObject.getClass(), referenceObjectName)
                    || persistenceStructureService.hasCollection(businessObject.getClass(), referenceObjectName)) {
                retrieveReferenceObject(businessObject, referenceObjectName);
            }
        }
    }

    @Override
    public boolean isLockable(Object object) {
        return isPersistable(object.getClass());
    }

    @Override
    public void verifyVersionNumber(Object dataObject) {
        if (isPersistable(dataObject.getClass())) {
            Object pbObject = businessObjectService.retrieve(dataObject);
            if ( dataObject instanceof Versioned ) {
	            Long pbObjectVerNbr = KRADUtils.isNull(pbObject) ? null : ((Versioned) pbObject).getVersionNumber();
	            Long newObjectVerNbr = ((Versioned) dataObject).getVersionNumber();
	            if (pbObjectVerNbr != null && !(pbObjectVerNbr.equals(newObjectVerNbr))) {
	                GlobalVariables.getMessageMap().putError(KRADConstants.GLOBAL_ERRORS,
	                        RiceKeyConstants.ERROR_VERSION_MISMATCH);
	                throw new ValidationException(
	                        "Version mismatch between the local business object and the database business object");
	            }
            }
        }
    }

    @Override
    public RemotableQuickFinder.Builder createQuickFinder(Class<?> containingClass, String attributeName) {
        return createQuickFinderLegacy(containingClass, attributeName);
    }

    /**
     * Legacy implementation of createQuickFinder. Uses the legacy DataObjectMetadataService.
     */
    protected RemotableQuickFinder.Builder createQuickFinderLegacy(Class<?> containingClass, String attributeName) {
        Object sampleComponent;
        try {
            sampleComponent = containingClass.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            throw new RiceRuntimeException(e);
        }

        String lookupClassName = null;
        Map<String, String> fieldConversions = new HashMap<>();
        Map<String, String> lookupParameters = new HashMap<>();

        org.kuali.rice.krad.bo.DataObjectRelationship relationship =
                getDataObjectRelationship(sampleComponent, containingClass, attributeName, "",
                        true, true, false);
        if (relationship != null) {
            lookupClassName = relationship.getRelatedClass().getName();

            for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
                String fromField = entry.getValue();
                String toField = entry.getKey();
                fieldConversions.put(fromField, toField);
            }

            for (Map.Entry<String, String> entry : relationship.getParentToChildReferences().entrySet()) {
                String fromField = entry.getKey();
                String toField = entry.getValue();

                if (relationship.getUserVisibleIdentifierKey() == null || relationship.getUserVisibleIdentifierKey()
                        .equals(fromField)) {
                    lookupParameters.put(fromField, toField);
                }
            }
        } else {
            // check for title attribute and if match build lookup to component class using pk fields
            String titleAttribute = dataObjectMetaDataService.getTitleAttribute(containingClass);
            if (StringUtils.equals(titleAttribute, attributeName)) {
                lookupClassName = containingClass.getName();

                List<String> pkAttributes = dataObjectMetaDataService.listPrimaryKeyFieldNames(containingClass);
                for (String pkAttribute : pkAttributes) {
                    fieldConversions.put(pkAttribute, pkAttribute);
                    if (!StringUtils.equals(pkAttribute, attributeName)) {
                        lookupParameters.put(pkAttribute, pkAttribute);
                    }
                }
            }
        }

        if (StringUtils.isNotBlank(lookupClassName)) {
            String baseUrl = kualiConfigurationService.getPropertyValueAsString(KRADConstants.KRAD_LOOKUP_URL_KEY);
            RemotableQuickFinder.Builder builder = RemotableQuickFinder.Builder.create(baseUrl, lookupClassName);
            builder.setLookupParameters(lookupParameters);
            builder.setFieldConversions(fieldConversions);

            return builder;
        }

        return null;
    }


    @Override
    public boolean isReferenceUpdatable(Class<?> type, String referenceName) {
        return persistenceStructureService.isReferenceUpdatable(type, referenceName);
    }

    @Override
    public Map<String, Class<?>> listReferenceObjectFields(Class<?> type) {
        return coerce(persistenceStructureService.listReferenceObjectFields(type));
    }

    @Override
    public boolean isCollectionUpdatable(Class<?> type, String collectionName) {
        return persistenceStructureService.isCollectionUpdatable(type, collectionName);
    }

    @Override
    public Map<String, Class<?>> listCollectionObjectTypes(Class<?> type) {
        return coerce(persistenceStructureService.listCollectionObjectTypes(type));
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    private Map<String, Class<?>> coerce(Map map) {
        return map;
    }

    @Override
    public BusinessObject getReferenceIfExists(Object bo, String referenceName) {
        if (!(bo instanceof BusinessObject)) {
            throw new UnsupportedOperationException("getReferenceIfExists only supports BusinessObject in KNS");
        }

        return businessObjectService.getReferenceIfExists((BusinessObject) bo, referenceName);
    }

    @Override
    public boolean allForeignKeyValuesPopulatedForReference(Object bo, String referenceName) {
        if (!(bo instanceof PersistableBusinessObject)) {
            throw new UnsupportedOperationException(
                    "getReferenceIfExists only supports PersistableBusinessObject in KNS");
        }

        return persistenceService.allForeignKeyValuesPopulatedForReference((PersistableBusinessObject) bo,
                referenceName);
    }

    /**
     * gets the relationship that the attribute represents on the class
     *
     * @param c - the class to which the attribute belongs
     * @param attributeName - property name for the attribute
     * @return a relationship definition for the attribute
     */
    @Override
    public RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName) {
        DataDictionaryEntry entryBase =
                getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(
                        c.getName());
        if (entryBase == null) {
            return null;
        }

        RelationshipDefinition relationship = null;

        List<RelationshipDefinition> ddRelationships = entryBase.getRelationships();

        int minKeys = Integer.MAX_VALUE;
        for (RelationshipDefinition def : ddRelationships) {
            // favor key sizes of 1 first
            if (def.getPrimitiveAttributes().size() == 1) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (primitive.getSourceName().equals(attributeName) || def.getObjectAttributeName().equals(
                            attributeName)) {
                        relationship = def;
                        minKeys = 1;
                        break;
                    }
                }
            } else if (def.getPrimitiveAttributes().size() < minKeys) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (primitive.getSourceName().equals(attributeName) || def.getObjectAttributeName().equals(
                            attributeName)) {
                        relationship = def;
                        minKeys = def.getPrimitiveAttributes().size();
                        break;
                    }
                }
            }
        }

        // check the support attributes
        if (relationship == null) {
            for (RelationshipDefinition def : ddRelationships) {
                if (def.hasIdentifier()) {
                    if (def.getIdentifier().getSourceName().equals(attributeName)) {
                        relationship = def;
                    }
                }
            }
        }

        return relationship;
    }

    @Override
    public String getTitleAttribute(Class<?> dataObjectClass) {
        String titleAttribute = null;
        DataObjectEntry entry = getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    /**
     * @return DataObjectEntry for the given dataObjectClass, or null if
     *         there is none
     * @throws IllegalArgumentException if the given Class is null
     */
    protected DataObjectEntry getDataObjectEntry(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }

        return dataDictionaryService.getDataDictionary().getDataObjectEntry(dataObjectClass.getName());
    }

    @Override
    public boolean areNotesSupported(Class<?> dataObjectClass) {
        boolean hasNotesSupport = false;

        DataObjectEntry entry = getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            hasNotesSupport = entry.isBoNotesEnabled();
        }

        return hasNotesSupport;
    }

    /**
     * Grabs primary key fields and sorts them if sort field names is true
     * @return Map of sorted primary key field values
     */
    protected Map<String, ?> getPrimaryKeyFieldValues(Object dataObject, boolean sortFieldNames) {
        Map<String, ?> keyFieldValues = getPrimaryKeyFieldValues(dataObject);
        if (sortFieldNames) {
            return new TreeMap<>(keyFieldValues);
        }
        return keyFieldValues;
    }

    @Override
    public String getDataObjectIdentifierString(Object dataObject) {
        String identifierString = "";

        if (dataObject == null) {
            identifierString = "Null";
            return identifierString;
        }

        Class<?> dataObjectClass = dataObject.getClass();
        // if Legacy and a PersistableBusinessObject or if not Legacy and implement GlobalLyUnique use the object id field
        if ((PersistableBusinessObject.class.isAssignableFrom(
                dataObjectClass)) || (!LegacyUtils.useLegacyForObject(dataObject) && GloballyUnique.class
                .isAssignableFrom(dataObjectClass))) {
            String objectId = ObjectPropertyUtils.getPropertyValue(dataObject, UifPropertyPaths.OBJECT_ID);
            if (StringUtils.isBlank(objectId)) {
                objectId = UUID.randomUUID().toString();
                ObjectPropertyUtils.setPropertyValue(dataObject, UifPropertyPaths.OBJECT_ID, objectId);
            }
        }
        return identifierString;
    }

    @Override
    public Class<?> getInquiryObjectClassIfNotTitle(Object dataObject, String propertyName) {
        Class<?> objectClass = ObjectUtils.materializeClassForProxiedObject(dataObject);
        org.kuali.rice.krad.bo.DataObjectRelationship relationship =
                dataObjectMetaDataService.getDataObjectRelationship(dataObject, objectClass, propertyName, "", true,
                        false, true);
        if (relationship != null) {
            return relationship.getRelatedClass();
        }
        return null;
    }

    @Override
    public Map<String, String> getInquiryParameters(Object dataObject, List<String> keys, String propertyName) {
        Map<String, String> inquiryParameters = new HashMap<>();
        Class<?> objectClass = ObjectUtils.materializeClassForProxiedObject(dataObject);
        org.kuali.rice.krad.bo.DataObjectRelationship relationship =
                dataObjectMetaDataService.getDataObjectRelationship(dataObject, objectClass, propertyName, "", true,
                        false, true);
        for (String keyName : keys) {
            String keyConversion = keyName;
            if (relationship != null) {
                keyConversion = relationship.getParentAttributeForChildAttribute(keyName);
            } else if (PropertyAccessorUtils.isNestedOrIndexedProperty(propertyName)) {
                String nestedAttributePrefix = KRADUtils.getNestedAttributePrefix(propertyName);
                keyConversion = nestedAttributePrefix + "." + keyName;
            }
            inquiryParameters.put(keyConversion, keyName);
        }
        return inquiryParameters;
    }

    @Override
    public boolean hasLocalLookup(Class<?> dataObjectClass) {
        return dataObjectMetaDataService.hasLocalLookup(dataObjectClass);
    }

    @Override
    public boolean hasLocalInquiry(Class<?> dataObjectClass) {
        return dataObjectMetaDataService.hasLocalInquiry(dataObjectClass);
    }

    @Override
    public org.kuali.rice.krad.bo.DataObjectRelationship getDataObjectRelationship(Object dataObject,
            Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly,
            boolean supportsLookup, boolean supportsInquiry) {
        getDictionaryRelationship(dataObjectClass, attributeName);
        return dataObjectMetaDataService.getDataObjectRelationship(dataObject, dataObjectClass, attributeName,
                    attributePrefix, keysOnly, supportsLookup, supportsInquiry);

    }

    @Override
	public boolean isPersistable(Class<?> dataObjectClass) {
        return persistenceStructureService.isPersistable(dataObjectClass);
    }

    @Override
    public <T> void setObjectPropertyDeep(Object bo, String propertyName, Class<T> type,
            T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectUtils.setObjectPropertyDeep(bo,propertyName,type,propertyValue);
    }

    @Override
    public boolean isNull(Object object){
         return ObjectUtils.isNull(object);
    }

    @Override
    public <T> void setObjectProperty(Object bo, String propertyName, Class<T> propertyType,
            T propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException{
        ObjectUtils.setObjectProperty(bo,propertyName,propertyType,propertyValue);
    }

    @Override
	public <T> Class<T> materializeClassForProxiedObject(T object){
        return ObjectUtils.materializeClassForProxiedObject(object);
    }

    @Override
	public Object getNestedValue(Object bo, String fieldName){
        return ObjectUtils.getNestedValue(bo,fieldName);
    }

    @Override
	public <T> T createNewObjectFromClass(Class<T> clazz){
        return (T) ObjectUtils.createNewObjectFromClass(clazz);
    }

    @Override
    public ForeignKeyFieldsPopulationState getForeignKeyFieldsPopulationState(Object dataObject, String referenceName) {
        return persistenceStructureService.getForeignKeyFieldsPopulationState(
                    (PersistableBusinessObject) dataObject, referenceName);
    }

    @Override
    public Map<String, String> getForeignKeysForReference(Class<?> clazz, String attributeName) {
        return persistenceStructureService.getForeignKeysForReference(clazz, attributeName);
    }

    @Override
    public boolean hasPrimaryKeyFieldValues(Object dataObject) {
        return persistenceStructureService.hasPrimaryKeyFieldValues(dataObject);
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> documentClass, String id) {
        return documentDao.findByDocumentHeaderId(documentClass, id);
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> documentClass, List<String> ids) {
        return documentDao.findByDocumentHeaderIds(documentClass, ids);
    }

    protected void synchronizeEclipseLinkWeavings(Object persistableObject, String propertyName) {
        if (LegacyUtils.isKradDataManaged(persistableObject.getClass())) {
            List<ValueHolderFieldPair> fieldPairs = loadValueHolderFieldPairs(persistableObject.getClass());
            for (ValueHolderFieldPair fieldPair : fieldPairs) {
                if (fieldPair.field.getName().equals(propertyName)) {
                    fieldPair.synchronizeValueHolder(persistableObject);
                }
            }
        }
    }

    protected void synchronizeEclipseLinkWeavings(Object persistableObject) {
        if (LegacyUtils.isKradDataManaged(persistableObject.getClass())) {
            List<ValueHolderFieldPair> fieldPairs = loadValueHolderFieldPairs(persistableObject.getClass());
            for (ValueHolderFieldPair fieldPair : fieldPairs) {
                fieldPair.synchronizeValueHolder(persistableObject);
            }
        }
    }

    private List<ValueHolderFieldPair> loadValueHolderFieldPairs(Class<?> type) {
        if (valueHolderFieldCache.get(type) == null) {
            List<ValueHolderFieldPair> pairs = new ArrayList<>();
            searchValueHolderFieldPairs(type, pairs);
            valueHolderFieldCache.putIfAbsent(type, pairs);
        }
        return valueHolderFieldCache.get(type);
    }

    private void searchValueHolderFieldPairs(Class<?> type, List<ValueHolderFieldPair> pairs) {
        if (type.equals(Object.class)) {
            return;
        }
        for (Field valueHolderField : type.getDeclaredFields()) {
            Matcher matcher = VALUE_HOLDER_FIELD_PATTERN.matcher(valueHolderField.getName());
            if (matcher.matches()) {
                valueHolderField.setAccessible(true);
                String fieldName = matcher.group(1);
                Field valueField = FieldUtils.getDeclaredField(type, fieldName, true);
                if (valueField != null) {
                    pairs.add(new ValueHolderFieldPair(valueField, valueHolderField));
                }
            }
        }
        searchValueHolderFieldPairs(type.getSuperclass(), pairs);
    }

    @Required
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Required
    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Required
    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    @Required
    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    @Required
    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    @Required
    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @Required
    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    @Required
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Required
    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    /**
     * Holds a reference to a property Field on a JPA entity and the associated EclipseLink {@link org.eclipse.persistence.indirection.ValueHolder} field.
     *
     * <p>This exists to support the issue of using a data object with both OJB and JPA. EclipseLink will "instrument"
     * the entity class using load-time or static weaving (depending on what's been configured). For fields which are
     * FetchType.LAZY, EclipseLink will weave a private internal field with a name like "_persistence_propertyName_vh"
     * where "propertyName" is the name of the property which is lazy. This type of this field is {@link org.eclipse.persistence.indirection.ValueHolder}.
     * In this case, if you call getPropertyName for the property, the internal code will pull the value from the
     * ValueHolder instead of the actual property field. Oftentimes this will be ok because the two fields will be in
     * sync, but when using methods like OJB's retrieveReference and retrieveAllReferences, after the "retrieve" these
     * values will be out of sync. So the {@link #synchronizeValueHolder(Object)} method on this class can be used to
     * synchronize these values and ensure that the local field has a value which matches the ValueHolder.</p>
     */
    private static final class ValueHolderFieldPair {

        final Field field;
        final Field valueHolderField;

        ValueHolderFieldPair(Field field, Field valueHolderField) {
            this.field = field;
            this.valueHolderField = valueHolderField;
        }

        void synchronizeValueHolder(Object object) {
            try {
                ValueHolder valueHolder = (ValueHolder)valueHolderField.get(object);
                if(valueHolder != null){
                    Object value = field.get(object);
                    valueHolder.setValue(value);
                }
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

    }

    public BusinessObjectService getBusinessObjectService() {
        return businessObjectService;
    }

    public PersistenceService getPersistenceService() {
        return persistenceService;
    }

    public LookupDao getLookupDao() {
        return lookupDao;
    }

    public DocumentDao getDocumentDao() {
        return documentDao;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        return persistenceStructureService;
    }

    public DataObjectMetaDataService getDataObjectMetaDataService() {
        return dataObjectMetaDataService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return kualiConfigurationService;
    }

    public KualiModuleService getKualiModuleService() {
        return kualiModuleService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return dataDictionaryService;
    }
}
