/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.platform;

import org.apache.ojb.broker.PersistenceBroker;

import java.sql.Connection;
import java.util.regex.Pattern;

/**
 * DatabasePlatform implementation that generates Derby-compliant SQL
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DerbyDatabasePlatform extends ANSISqlDatabasePlatform {

	private static final Pattern APOS_PAT = Pattern.compile("'");
	
    @Override
    public String getLockRouteHeaderQuerySQL(String documentId, boolean wait) {
        return "SELECT DOC_HDR_ID FROM KREW_DOC_HDR_T WHERE DOC_HDR_ID=?";
    }

    private static long nextVal = 1000;
    
	@Override
    public String getCurTimeFunction() {
		return "CURRENT_TIMESTAMP";
	}

	@Override
    public String getDateFormatString(String dateFormatString) {
		return "'" + dateFormatString + "'";
	}
    
	@Override
    public String getStrToDateFunction() {
		return null;
	}

    @Override
    protected Long getNextValSqlOjb(String sequenceName, PersistenceBroker persistenceBroker) {
        return nextVal++;
    }

    @Override
    protected Long getNextValSqlJdbc(String sequenceName, Connection connection) {
        return nextVal++;
    }

    @Override
    public String toString() {
        return "[Derby]";
    }

    @Override
    public String getSelectForUpdateSuffix(long waitMillis) {
    	throw new UnsupportedOperationException("Implement me!");
    }

    /**
     * Performs Derby-specific escaping of String parameters.
     * 
     * @see DatabasePlatform#escapeString(java.lang.String)
     */
    @Override
    public String escapeString(String sqlString) {
    	return (sqlString != null) ? APOS_PAT.matcher(sqlString).replaceAll("''") : null;
    }

    @Override
    public String applyLimitSql(Integer limit) {
        // derby has no such concept
        return null;
    }
}
