/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.control;


/**
 * The currency element defines an HTML text control for entering dollar and cents amounts.  Only two decimals to the
 * right of the decimal point are allowed.  Formatted value is displayed with commas.
 *
 * Used Properties: size, formattedMaxLength
 *
 * @deprecated Only used by KNS classes, use KRAD.
 */
@Deprecated
public class CurrencyControlDefinition extends ControlDefinitionBase {
    private static final long serialVersionUID = 1650000676894176080L;
    
	/**
     * the maxLength for text that has been formatted. ie if maxLength=5. [12345]. but after going through the formatter the value
     * is [12,345.00] and will no longer fit in a field whos maxLength=5. formattedMaxLength solves this problem.
     */
    protected Integer formattedMaxLength;

    public CurrencyControlDefinition() {
    }

    /**
     * 
     * @see org.kuali.rice.krad.datadictionary.control.ControlDefinition#isCurrency()
     */
    @Override
    public boolean isCurrency() {
        return true;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "CurrencyControlDefinition";
    }

    /**
     * @return Returns the formattedMaxLength parameter for currency controls.
     */
    public Integer getFormattedMaxLength() {
        return formattedMaxLength;
    }

    /**
     * the maxLength for text that has been formatted. ie if maxLength=5. [12345]. but after going through the formatter the value
     * is [12,345.00] and will no longer fit in a field whos maxLength=5. formattedMaxLength solves this problem.
     */
    public void setFormattedMaxLength(Integer formattedMaxLength) {
        this.formattedMaxLength = formattedMaxLength;
    }

}
