/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.control;

import org.kuali.rice.krad.datadictionary.exception.CompletionException;

/**
 * Base class for control which provide a list of values to choose between.
 *
 * @deprecated Only used by KNS classes, use KRAD.
 */
@Deprecated
public abstract class MultivalueControlDefinitionBase extends ControlDefinitionBase {
    private static final long serialVersionUID = -9164657952021540261L;

    @Override
    public void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass) {
        super.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass);

        String valuesFinder = getValuesFinderClass();
        if (valuesFinder == null) {
            throw new CompletionException("error validating " + rootBusinessObjectClass.getName() + " control: keyValuesFinder was never set (" + "" + ")");
        }
    }
}
