/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util;

import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.collect.CollectionUtils;

import java.util.Enumeration;

/**
 * Utility for that is used along with the tableRenderPagingBanner.tag.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public final class PagingBannerUtils {

	/** do not call. */
	private PagingBannerUtils() {
		throw new UnsupportedOperationException("do not call");
	}
	
    /**
     * find the number string in a method to call parameter with the following format parameterPrefix.1 or
     * parameterPrefix.1.bleh
     * 
     * @param paramPrefix the 
     * @param parameterNames the parameter names.
     * @return the numerical value or -1
     */
    public static int getNumbericalValueAfterPrefix(String paramPrefix, Enumeration<String> parameterNames) {
            	
    	for (String parameterName : CollectionUtils.toIterable(parameterNames)) {
    		if (parameterName.startsWith(paramPrefix)) {
            	parameterName = WebUtils.endsWithCoordinates(parameterName) ? parameterName : parameterName + ".x";
            	String numberStr = StringUtils.substringBetween(parameterName, paramPrefix, ".");
            	if (NumberUtils.isDigits(numberStr)) {
            		return Integer.parseInt(numberStr);
            	}
            }
        }

    	return -1;
    }

    /**
     * same as method above except for use when it is not feasible to use ordinals to identify columns -- for example,
     * if dynamic attributes may be used
     */
    public static String getStringValueAfterPrefix(String paramPrefix, Enumeration<String> parameterNames) {
        for (String parameterName : CollectionUtils.toIterable(parameterNames)) {
            if (parameterName.startsWith(paramPrefix)) {
                parameterName = WebUtils.endsWithCoordinates(parameterName) ? parameterName : parameterName + ".x";
                return StringUtils.substringBetween(parameterName, paramPrefix, ".");
            }
        }

        return "";
    }
}
