/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import java.util.HashSet;
import java.util.Set;

import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

/**
 * Base class for all MaintenanceDocumentPresentationControllers.
 *
 * @deprecated Use {@link org.kuali.rice.krad.maintenance.MaintenanceDocumentPresentationControllerBase}.
 */
@Deprecated
public class MaintenanceDocumentPresentationControllerBase extends DocumentPresentationControllerBase
       implements MaintenanceDocumentPresentationController {
	private static final long serialVersionUID = 1L;

	@Override
    public boolean canCreate(Class boClass) {
        return KRADServiceLocatorWeb.getDocumentDictionaryService().getAllowsNewOrCopy(
                KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(boClass));
    }

    @Override
    public boolean canMaintain(Object dataObject) {
        return true;
    }

    @Override
    public Set<String> getConditionallyHiddenPropertyNames(Object businessObject) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getConditionallyHiddenSectionIds(Object businessObject) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getConditionallyReadOnlyPropertyNames(MaintenanceDocument document) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getConditionallyReadOnlySectionIds(MaintenanceDocument document) {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getConditionallyRequiredPropertyNames(MaintenanceDocument document) {
        return new HashSet<String>();
    }
}
