/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb.conversion;

import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

/**
 * Performs conversion of java boolean fields to and from the database
 */
public class OjbCharBooleanConversion implements FieldConversion {
	public static final String DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION = "Y";
	public static final String DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION = "N";

    /**
     * @see FieldConversion#javaToSql(Object)
     */
    @Override
    public Object javaToSql(Object source) {
        if (source instanceof Boolean) {
            if (source != null) {
                Boolean b = (Boolean) source;
                return b.booleanValue() ? DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION : DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION;
            }
            else {
                return null;
            }
        }
        else if (source instanceof String) {
            if ("true".equalsIgnoreCase((String)source) || "yes".equalsIgnoreCase((String)source) || "y".equalsIgnoreCase((String)source)) {
                return DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION;
            }
            else if ("false".equalsIgnoreCase((String)source) || "no".equalsIgnoreCase((String)source) || "n".equalsIgnoreCase((String)source)) {
                return DATABASE_BOOLEAN_FALSE_STRING_REPRESENTATION;
            }
        }
        return source;
    }

    /**
     * @see FieldConversion#sqlToJava(Object)
     */
    @Override
    public Object sqlToJava(Object source) {
        try {
            if (source instanceof String) {
                if (source != null) {
                    String s = (String) source;
                    String trueValues = DATABASE_BOOLEAN_TRUE_STRING_REPRESENTATION + "T1";
                    return trueValues.contains(s);
                }
                else {
                    return null;
                }
            }
            return source;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("I have exploded converting types", t);
        }
    }

}
