/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.kim.permission;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.framework.permission.PermissionTypeService;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @deprecated A krad integrated type service base class will be provided in the future.
 */
@Deprecated
public class PermissionTypeServiceBase extends DataDictionaryTypeServiceBase implements PermissionTypeService {

	@Override
	public final List<Permission> getMatchingPermissions(Map<String, String> requestedDetails, List<Permission> permissionsList) {
		requestedDetails = translateInputAttributes(requestedDetails);
		validateRequiredAttributesAgainstReceived(requestedDetails);
		return Collections.unmodifiableList(performPermissionMatches(requestedDetails, permissionsList));
	}

	/**
	 * Internal method for matching permissions.  Override this method to customize the matching behavior.
	 * 
	 * This base implementation uses the {@link #performMatch(Map, Map)} method
	 * to perform an exact match on the permission details and return all that are equal.
	 */
	protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
		List<Permission> matchingPermissions = new ArrayList<Permission>();
		for (Permission permission : permissionsList) {
			if ( performMatch(requestedDetails, permission.getAttributes()) ) {
				matchingPermissions.add( permission );
			}
		}
		return matchingPermissions;
	}
	
	/**
	 * 
	 * Internal method for checking if property name matches
	 * 
	 * @param requestedDetailsPropertyName name of requested details property
	 * @param permissionDetailsPropertyName name of permission details property
	 * @return boolean 
	 */
	protected boolean doesPropertyNameMatch(
			String requestedDetailsPropertyName,
			String permissionDetailsPropertyName) {
		if (StringUtils.isBlank(permissionDetailsPropertyName)) {
			return true;
		}
		if ( requestedDetailsPropertyName == null ) {
		    requestedDetailsPropertyName = ""; // prevent NPE
		}
		return StringUtils.equals(requestedDetailsPropertyName, permissionDetailsPropertyName)
				|| (requestedDetailsPropertyName.startsWith(permissionDetailsPropertyName+"."));
	}
}
