/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.util.documentserlializer;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSubSectionHeaderDefinition;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluatorBase;
import org.kuali.rice.krad.util.documentserializer.PropertySerializerTrie;
import org.kuali.rice.krad.util.documentserializer.PropertyType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class MaintenanceDocumentPropertySerializibilityEvaluator
				extends PropertySerializabilityEvaluatorBase implements PropertySerializabilityEvaluator {

    /**
     * Reads the data dictionary to determine which properties of the document should be serialized.
     * 
     * @see org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator#initializeEvaluator(org.kuali.rice.krad.document.Document)
     */
	@Override
    public void initializeEvaluatorForDataObject(Object businessObject){
        DataDictionary dictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
        MaintenanceDocumentEntry maintenanceDocumentEntry = (MaintenanceDocumentEntry)
        	dictionary.getMaintenanceDocumentEntryForBusinessObjectClass(businessObject.getClass());
        serializableProperties = new PropertySerializerTrie();
        populateSerializableProperties(maintenanceDocumentEntry.getMaintainableSections());
        serializableProperties.addSerializablePropertyName("boNotes", true);
        serializableProperties.addSerializablePropertyName("boNotes.attachment", true);
    }

    /**
     * @see org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator#determinePropertyType(java.lang.Object)
     */
    @Override
    public PropertyType determinePropertyType(Object propertyValue) {
        if (propertyValue == null) {
            return PropertyType.PRIMITIVE;
        }

        if (propertyValue instanceof BusinessObject) {
            return PropertyType.BUSINESS_OBJECT;
        }

        if (propertyValue instanceof Collection) {
            return PropertyType.COLLECTION;
        }

        // In the case of Maintenance Documents treat Maps as PRIMITIVE
        if (propertyValue instanceof Map) {
            return PropertyType.PRIMITIVE;
        }

        return PropertyType.PRIMITIVE;
    }

    private void populateSerializableProperties(List<MaintainableSectionDefinition> maintainableSectionDefinitions){
        for(MaintainableSectionDefinition maintainableSectionDefinition: maintainableSectionDefinitions){
        	populateSerializablePropertiesWithItems("", maintainableSectionDefinition.getMaintainableItems());
        }
    }

    private void populateSerializablePropertiesWithItems(String basePath, List<MaintainableItemDefinition> maintainableItems){
    	for(MaintainableItemDefinition maintainableItemDefinition: maintainableItems){
            if(maintainableItemDefinition instanceof MaintainableFieldDefinition){
                serializableProperties.addSerializablePropertyName(getFullItemName(basePath, maintainableItemDefinition.getName()), true);
            } else if(maintainableItemDefinition instanceof MaintainableCollectionDefinition){
            	serializableProperties.addSerializablePropertyName(getFullItemName(basePath, maintainableItemDefinition.getName()), true);
            	populateSerializablePropertiesWithItems(getFullItemName(basePath, maintainableItemDefinition.getName()), 
            			getAllMaintainableFieldDefinitionsForSerialization(
            			(MaintainableCollectionDefinition)maintainableItemDefinition));            	
            } else if(maintainableItemDefinition instanceof MaintainableSubSectionHeaderDefinition){
            	//Ignore
            }
    	}
    }

    private String getFullItemName(String basePath, String itemName){
    	return StringUtils.isEmpty(basePath) ? itemName : basePath+"."+itemName;
    }
    
    public List<MaintainableItemDefinition> getAllMaintainableFieldDefinitionsForSerialization(
    		MaintainableCollectionDefinition maintainableCollectionDefinition){
		List<MaintainableItemDefinition> allMaintainableItemDefinitions = new ArrayList<MaintainableItemDefinition>();

		if(maintainableCollectionDefinition.getMaintainableFields()!=null){
			allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getMaintainableFields());
		}

		if(maintainableCollectionDefinition.getSummaryFields()!=null){
			allMaintainableItemDefinitions.addAll(
					(List<MaintainableFieldDefinition>)maintainableCollectionDefinition.getSummaryFields());
		}

		if(maintainableCollectionDefinition.getDuplicateIdentificationFields()!=null){
			allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getDuplicateIdentificationFields());
		}

		/*if(maintainableCollectionMap!=null){
			updateMaintainableCollectionDefinitionForSerialization(maintainableCollectionMap.values());
			allMaintainableItemDefinitions.addAll(maintainableCollectionMap.values());
		}*/
		if(maintainableCollectionDefinition.getMaintainableCollections()!=null){
			allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getMaintainableCollections());
		}

		return allMaintainableItemDefinitions;
	}
    
}
