/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import java.sql.Timestamp;

import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.web.form.DocumentFormBase;

/**
 * Service API for persisting <code>Document</code> form content and
 * retrieving back
 *
 * @deprecated (Deprecated and removed from use in KRAD  (KULRICE-9149)
 *
 * <p>
 * Used as an extension to session support. If a session times out, the doucment contents
 * can be retrieved from the persistence storage and work resumed
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Deprecated
public interface SessionDocumentService {

    /**
     * Retrieves a document from the user session for the given document id
     */
    public WorkflowDocument getDocumentFromSession(UserSession userSession, String docId);

    /**
     * This method places a document into the user session.
     */
    public void addDocumentToUserSession(UserSession userSession, WorkflowDocument document);

     /**
     * Delete DocumentFormBase from session and database.
     *
     * @param documentNumber
     * @param docFormKey
     * @param userSession
     * @throws
     */
    public void purgeDocumentForm(String documentNumber, String docFormKey, UserSession userSession, String ipAddress);

	/**
     * Delete KualiDocumentFormBase from session and database.
     *
     * @param documentNumber
     * @throws
     */
    public void purgeAllSessionDocuments(Timestamp expirationDate);

    /**
     * This method stores a UifFormBase into session and database
     *
     * @param form
     * @param userSession
     * @param ipAddress
     */
    public void setDocumentForm(DocumentFormBase form, UserSession userSession, String ipAddress);

    /**
     * Returns DocumentFormBase object from the db
     *
     * @param documentNumber
     * @param docFormKey
     * @param userSession
     * @param ipAddress
     * @return
     */
    public DocumentFormBase getDocumentForm(String documentNumber, String docFormKey, UserSession userSession,
            String ipAddress);
}
