/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;


@Entity
@Table(name="KRNS_NTE_TYP_T",uniqueConstraints= {
        @UniqueConstraint(name="KRNS_NTE_TYP_TC0",columnNames="OBJ_ID")
})
public class NoteType extends PersistableBusinessObjectBaseAdapter implements MutableInactivatable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="NTE_TYP_CD",length=4)
	private String noteTypeCode;
	@Column(name="TYP_DESC_TXT",length=100,nullable=false)
	private String noteTypeDescription;
	@Column(name="ACTV_IND",length=1)
    @javax.persistence.Convert(converter=BooleanYNConverter.class)
	private Boolean noteTypeActiveIndicator;

	public NoteType() {

	}

	/**
	 * Gets the noteTypeCode attribute.
	 *
	 * @return Returns the noteTypeCode
	 *
	 */
	public String getNoteTypeCode() {
		return noteTypeCode;
	}

	/**
	 * Sets the noteTypeCode attribute.
	 *
	 * @param noteTypeCode The noteTypeCode to set.
	 *
	 */
	public void setNoteTypeCode(String noteTypeCode) {
		this.noteTypeCode = noteTypeCode;
	}


	/**
	 * Gets the noteTypeDescription attribute.
	 *
	 * @return Returns the noteTypeDescription
	 *
	 */
	public String getNoteTypeDescription() {
		return noteTypeDescription;
	}

	/**
	 * Sets the noteTypeDescription attribute.
	 *
	 * @param noteTypeDescription The noteTypeDescription to set.
	 *
	 */
	public void setNoteTypeDescription(String noteTypeDescription) {
		this.noteTypeDescription = noteTypeDescription;
	}


	/**
	 * Gets the noteTypeActiveIndicator attribute.
	 *
	 * @return Returns the noteTypeActiveIndicator
	 *
	 */
	public boolean isNoteTypeActiveIndicator() {
		return noteTypeActiveIndicator;
	}


	/**
	 * Sets the noteTypeActiveIndicator attribute.
	 *
	 * @param noteTypeActiveIndicator The noteTypeActiveIndicator to set.
	 *
	 */
	public void setNoteTypeActiveIndicator(boolean noteTypeActiveIndicator) {
		this.noteTypeActiveIndicator = noteTypeActiveIndicator;
	}

	@Override
	public boolean isActive() {
	    return noteTypeActiveIndicator;
	}

	@Override
	public void setActive(boolean active) {
	    this.noteTypeActiveIndicator = active;
	}
}

