/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.rice.krad.util;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class QueryPagingResults<T> implements Serializable {

    private final QueryPagingRequest pagingRequest;
    private final List<T> results;
    private final int total;

    public QueryPagingResults(QueryPagingRequest pagingRequest, List<T> results, int total) {
        this.pagingRequest = pagingRequest;
        this.results = results;
        this.total = total;
    }

    public QueryPagingRequest getPagingRequest() {
        return pagingRequest;
    }

    public List<T> getResults() {
        return results;
    }

    public int getTotal() {
        return total;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryPagingResults<?> that = (QueryPagingResults<?>) o;
        return total == that.total &&
                Objects.equals(pagingRequest, that.pagingRequest) &&
                Objects.equals(results, that.results);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pagingRequest, results, total);
    }

    @Override
    public String toString() {
        return "QueryPagingResults{" +
                "pagingRequest=" + pagingRequest +
                ", results=" + results +
                ", total=" + total +
                '}';
    }
}
