/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.exception;

import org.kuali.rice.core.api.util.RiceKeyConstants;

import java.util.Collections;
import java.util.Map;

/**
 * Represents an exception that is thrown when a given user is not authorized to take a given action on the given
 * document type
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentAuthorizationException extends AuthorizationException {

    /**
     * Constructs a DocumentAuthorizationException for a specific document rather than a documentType.
     *
     * @param userId
     * @param action
     * @param documentId
     */
    public DocumentAuthorizationException(String userId, String action, String documentId) {
        this(userId, action, documentId, Collections.<String, Object>emptyMap());
    }

    public DocumentAuthorizationException(String userId, String action, String documentId,
            Map<String, Object> requestAuthDetails) {
        super(userId, action, documentId,
                "user '" + userId + "' is not authorized to " + action + " document '" + documentId + "'",
                requestAuthDetails);
    }

    /**
     * @see AuthorizationException#getErrorMessageKey()
     */
    @Override
    public String getErrorMessageKey() {
        return RiceKeyConstants.AUTHORIZATION_ERROR_DOCUMENT;
    }

}
