/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;

@Entity
@Table(name="KRNS_ADHOC_RTE_ACTN_RECIP_T", uniqueConstraints={@UniqueConstraint(name="KRNS_ADHOC_RTE_ACTN_RECIP_TC0", columnNames={"OBJ_ID"})})
public class AdHocRouteWorkgroup
extends AdHocRouteRecipient
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Transient
    private String recipientNamespaceCode;
    @Transient
    private String recipientName;
    @Transient
    private Group group;

    public AdHocRouteWorkgroup() {
        this.setType(WORKGROUP_TYPE);
    }

    @Override
    public void setType(Integer type) {
        if (!WORKGROUP_TYPE.equals(type)) {
            throw new IllegalArgumentException("cannot change type to " + type);
        }
        super.setType(type);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (StringUtils.isNotBlank((String)id)) {
            this.group = KimApiServiceLocator.getGroupService().getGroup(id);
            this.setGroup(this.group);
        }
    }

    @Override
    public String getName() {
        return "";
    }

    public String getRecipientNamespaceCode() {
        return this.recipientNamespaceCode;
    }

    public void setRecipientNamespaceCode(String recipientNamespaceCode) {
        this.recipientNamespaceCode = recipientNamespaceCode;
        if (StringUtils.isNotBlank((String)recipientNamespaceCode) && StringUtils.isNotBlank((String)this.recipientName)) {
            this.group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(recipientNamespaceCode, this.recipientName);
            this.setGroup(this.group);
        }
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
        if (StringUtils.isNotBlank((String)this.recipientNamespaceCode) && StringUtils.isNotBlank((String)recipientName)) {
            this.group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(this.recipientNamespaceCode, recipientName);
            this.setGroup(this.group);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
        if (group != null) {
            this._persistence_set_id(group.getId());
            this.recipientNamespaceCode = group.getNamespaceCode();
            this.recipientName = group.getName();
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdHocRouteWorkgroup();
    }

    @Override
    public Object _persistence_get(String string) {
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        super._persistence_set(string, object);
    }
}

