/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import org.kuali.rice.krad.data.jpa.IdClassBase;

/**
 * ID Class for SessionDocument.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class SessionDocumentId extends IdClassBase {

    private static final long serialVersionUID = 2455522802669321846L;

    private String sessionId;
	private String documentNumber;
	private String principalId;
	private String ipAddress;

	public SessionDocumentId() {}

	public SessionDocumentId(String documentNumber, String sessionId, String principalId, String ipAddress) {
		this.documentNumber = documentNumber;
		this.sessionId = sessionId;
		this.principalId = principalId;
		this.ipAddress = ipAddress;
	}

	public String getDocumentNumber() {
		return this.documentNumber;
	}

	public String getSessionId() {
		return this.sessionId;
	}

	public String getPrincipalId() {
		return this.principalId;
	}

	public String getIpAddress() {
		return this.ipAddress;
	}

}
