/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.bo;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;


/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@MappedSuperclass
public class PersistableAttachmentBase extends PersistableBusinessObjectBaseAdapter implements PersistableAttachment {

    private static final long serialVersionUID = 1L;


    /**
     * EclipseLink static weaving does not weave MappedSuperclass unless an Entity or Embedded is
     * weaved which uses it, hence this class.
     */
    @Embeddable
    private static final class WeaveMe extends PersistableAttachmentBase {}

    @Lob
	@Column(name = "ATT_CNTNT")
    private byte[] attachmentContent;

	@Column(name = "FILE_NM", length = 150)
    private String fileName;

	@Column(name = "CNTNT_TYP", length = 255)
    private String contentType;

    @Override
    public byte[] getAttachmentContent() {
        return this.attachmentContent;
    }

    @Override
    public void setAttachmentContent(byte[] attachmentContent) {
        this.attachmentContent = attachmentContent;
    }


    @Override
    public String getFileName() {
        return fileName;
    }


    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }


    @Override
    public String getContentType() {
        return contentType;
    }


    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}
