/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

/**
 * JPA specialization of DataObjectCriteriaQuery.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
class JpaCriteriaQuery extends DataObjectCriteriaQueryBase<TranslationContext, TypedQuery<?>, TypedQuery<Long>> {

    /**
     * The query translator to use for this implementation.
     */
    protected QueryTranslator<TranslationContext, TypedQuery<?>, TypedQuery<Long>> queryTranslator;

    /**
     * Creates a new JPA-specific criteria query.
     *
     * @param em the entity manager used in interacting with the database.
     */
    public JpaCriteriaQuery(EntityManager em) {
        this.queryTranslator = new NativeJpaQueryTranslator(em);
    }

    @Override
    protected QueryTranslator<TranslationContext, TypedQuery<?>, TypedQuery<Long>> getQueryTranslator() {
        return queryTranslator;
    }

    @Override
    public <T> List<T> getResults(TypedQuery<?> query) {
        return (List<T>) query.getResultList();
    }

    @Override
    public int executeUpdate(Query query) {
        return query.executeUpdate();
    }

    @Override
    protected int getRowCount(TypedQuery<Long> query) {
        return query.getSingleResult().intValue();
    }

    @Override
    public int getIncludedRowCount(TypedQuery<Long> query) {
        return getRowCount(query);
    }
}
