/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.provider.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates whether the attribute contents should be serialized in the given context(s).
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Serialized {

    /**
     * If true, this indicates that the marked field should be serialized for the indicated contexts, and if false
     * then the marked field should not.
     *
     * @return whether the marked field should be serialized
     */
    boolean enabled() default true;

    /**
     * The serialization contexts that {@link Serialized} applies to.
     *
     * @return the serialization contexts
     */
    SerializationContext[] forContexts() default { SerializationContext.ALL };
}
