/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.metadata.impl;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.springframework.beans.factory.annotation.Required;

public class MetadataRepositoryImpl
implements MetadataRepository {
    private ProviderRegistry registry;

    @Required
    public void setProviderRegistry(ProviderRegistry registry) {
        this.registry = registry;
    }

    @Override
    public synchronized DataObjectMetadata getMetadata(Class<?> type) {
        for (MetadataProvider provider : this.registry.getMetadataProviders()) {
            if (!provider.handles(type)) continue;
            return provider.getMetadataForType(type);
        }
        return null;
    }

    @Override
    public Map<Class<?>, DataObjectMetadata> getAllMetadata() {
        HashMap allMetaData = new HashMap();
        for (MetadataProvider provider : this.registry.getMetadataProviders()) {
            allMetaData.putAll(provider.provideMetadata());
        }
        return allMetaData;
    }

    @Override
    public boolean contains(Class<?> type) {
        return this.getMetadata(type) != null;
    }
}

