/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.provider.MetadataProvider;

public abstract class MetadataProviderBase
implements MetadataProvider {
    protected ConcurrentHashMap<Class<?>, DataObjectMetadata> masterMetadataMap = new ConcurrentHashMap();

    protected abstract void initializeMetadata(Collection<Class<?>> var1);

    @Override
    public boolean handles(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (this.masterMetadataMap.isEmpty()) {
            this.initializeMetadata(null);
        }
        return this.masterMetadataMap.containsKey(type);
    }

    @Override
    public Collection<Class<?>> getSupportedTypes() {
        if (this.masterMetadataMap.isEmpty()) {
            this.initializeMetadata(null);
        }
        return this.masterMetadataMap.keySet();
    }

    @Override
    public Map<Class<?>, DataObjectMetadata> provideMetadata() {
        return this.provideMetadataForTypes(null);
    }

    @Override
    public Map<Class<?>, DataObjectMetadata> provideMetadataForTypes(Collection<Class<?>> types) {
        if (this.masterMetadataMap.isEmpty()) {
            this.initializeMetadata(types);
            return Collections.unmodifiableMap(this.masterMetadataMap);
        }
        if (types == null || types.isEmpty()) {
            return Collections.unmodifiableMap(this.masterMetadataMap);
        }
        HashMap subMap = new HashMap();
        for (Class key : this.masterMetadataMap.keySet()) {
            if (!types.contains(key)) continue;
            subMap.put(key, this.masterMetadataMap.get(key));
        }
        return subMap;
    }

    @Override
    public DataObjectMetadata getMetadataForType(Class<?> dataObjectType) throws IllegalArgumentException {
        if (dataObjectType == null) {
            throw new IllegalArgumentException("getMetadataForType: NULL passed for the dataObjectType");
        }
        if (this.masterMetadataMap.isEmpty()) {
            this.initializeMetadata(null);
        }
        return this.masterMetadataMap.get(dataObjectType);
    }

    protected boolean isClassPersistable(Class<?> clazz) {
        if (this.masterMetadataMap.isEmpty()) {
            this.initializeMetadata(null);
        }
        return this.masterMetadataMap.containsKey(clazz);
    }

    @Override
    public boolean requiresListOfExistingTypes() {
        return false;
    }
}

