/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa;

/**
 * Operators used in the FilterGenerator annotation.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public enum FilterOperators {

    /**
     * The equal ("=") operator.
     */
    EQUAL("=");

    private String value;

    /**
     * Creates a filter operator.
     *
     * @param value the value of the operator.
     */
    FilterOperators(String value){
        this.value = value;
    }

    /**
     * Gets the value of the operator.
     *
     * @return the value of the operator.
     */
    public String getValue(){
        return this.value;
    }
}
