/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.metadata.MetadataRepository;
import org.kuali.rice.krad.data.provider.ProviderRegistry;

/**
 * Uses to locate services for the given service name.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KradDataServiceLocator {
    static <T> T getService(String serviceName) {
        return GlobalResourceLoader.<T>getService(serviceName);
    }

    public static DataObjectService getDataObjectService() {
        return getService("dataObjectService");
    }

    public static MetadataRepository getMetadataRepository() {
        return getService("metadataRepository");
    }

	public static ProviderRegistry getProviderRegistry() {
		return getService("providerRegistry");
	}
}
