/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata;

import java.io.Serializable;

/**
* Represents a single field on which to sort a {@link DataObjectCollection} within a {@link DataObjectMetadata}.
*
* <p>
* The collection may hold multiple of these objects to support sorting by multiple fields.
* </p>
*
* @author Kuali Rice Team (rice.collab@kuali.org)
*/
public interface DataObjectCollectionSortAttribute extends Serializable {

    /**
    * Gets attribute name.
    *
    * <p>
    * The attribute name on which to sort the collection.
    * </p>
    *
    * @return attribute name
    */
	String getAttributeName();

    /**
    * Gets the attribute sort.
    *
    * <p>
    * For this attribute, which way should we sort?.
    * </p>
    *
    * @return attribute sort
    */
	SortDirection getSortDirection();

}
