/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.metadata.impl;

import org.kuali.rice.krad.data.metadata.DataObjectCollectionSortAttribute;
import org.kuali.rice.krad.data.metadata.SortDirection;

/**
* {@inheritDoc}
*/
public class DataObjectCollectionSortAttributeImpl implements DataObjectCollectionSortAttribute {
	private static final long serialVersionUID = 2221451853788207680L;

	protected String attributeName;
	protected SortDirection sortDirection = SortDirection.ASCENDING;

	public DataObjectCollectionSortAttributeImpl() {
	}

	public DataObjectCollectionSortAttributeImpl(String attributeName, SortDirection sortDirection) {
		super();
		this.attributeName = attributeName;
		this.sortDirection = sortDirection;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public String getAttributeName() {
		return attributeName;
	}

    /**
    * Sets attribute name.
    *
    * @param attributeName attribute name
    */
	public void setAttributeName(String attributeName) {
		this.attributeName = attributeName;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public SortDirection getSortDirection() {
		return sortDirection;
	}

    /**
    * Sets sort direction.
    *
    * @param sortDirection sort direction.
    */
	public void setSortDirection(SortDirection sortDirection) {
		this.sortDirection = sortDirection;
	}

    /**
    * {@inheritDoc}
    */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[attributeName=").append(attributeName).append(" ").append(sortDirection).append("]");
		return builder.toString();
	}

}
