/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Chains multiple filter generators.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 **/
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
public @interface FilterGenerators {
    /**
     * Gets a list of filter generations.
     *
     * @return A list of filter generations.
     */
    FilterGenerator[] value();
}
