/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.MetadataCommon;
import org.kuali.rice.krad.data.metadata.MetadataMergeAction;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeInternal;
import org.kuali.rice.krad.data.metadata.impl.MetadataCommonInternal;

public abstract class MetadataCommonBase
implements MetadataCommonInternal {
    private static final long serialVersionUID = 2610090812919046672L;
    private static final Logger LOG = LogManager.getLogger(MetadataCommonBase.class);
    protected MetadataCommon embeddedCommonMetadata;
    protected MetadataMergeAction mergeAction = MetadataMergeAction.MERGE;
    protected String backingObjectName;
    protected String name;
    protected String label;
    protected String shortLabel;
    protected String description;
    protected Boolean readOnly = false;

    @Override
    public Object getUniqueKeyForMerging() {
        return this.name;
    }

    @Override
    public String getBackingObjectName() {
        if (this.backingObjectName != null) {
            return this.backingObjectName;
        }
        if (this.embeddedCommonMetadata != null) {
            return this.embeddedCommonMetadata.getBackingObjectName();
        }
        return this.getName();
    }

    public void setBackingObjectName(String backingObjectName) {
        this.backingObjectName = backingObjectName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.embeddedCommonMetadata != null) {
            return this.embeddedCommonMetadata.getLabel();
        }
        return this.getLabelFromPropertyName(this.name);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getShortLabel() {
        if (StringUtils.isNotBlank((String)this.shortLabel)) {
            return this.shortLabel;
        }
        if (this.embeddedCommonMetadata != null) {
            return this.embeddedCommonMetadata.getShortLabel();
        }
        return this.getLabel();
    }

    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.embeddedCommonMetadata != null) {
            return this.embeddedCommonMetadata.getDescription();
        }
        return "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isReadOnly() {
        if (this.readOnly != null) {
            return this.readOnly;
        }
        if (this.embeddedCommonMetadata != null) {
            return this.embeddedCommonMetadata.isReadOnly();
        }
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("name=").append(this.getName()).append(", ");
        builder.append("label=").append(this.getLabel()).append(", ");
        builder.append("backingObjectName=").append(this.getBackingObjectName()).append(", ");
        builder.append("readOnly=").append(this.isReadOnly());
        builder.append(", ").append("mergeAction=").append((Object)this.mergeAction);
        builder.append("]");
        return builder.toString();
    }

    protected String getLabelFromPropertyName(String propertyName) {
        if (propertyName.contains(".")) {
            propertyName = StringUtils.substringAfterLast((String)propertyName, (String)".");
        }
        StringBuilder label = new StringBuilder(propertyName);
        label.replace(0, 1, label.substring(0, 1).toUpperCase());
        for (int i = 0; i < label.length(); ++i) {
            if (!Character.isUpperCase(label.charAt(i)) && !Character.isDigit(label.charAt(i))) continue;
            label.insert(i, ' ');
            ++i;
        }
        return label.toString().trim();
    }

    @Override
    public MetadataCommon getEmbeddedCommonMetadata() {
        return this.embeddedCommonMetadata;
    }

    @Override
    public void setEmbeddedCommonMetadata(MetadataCommon embeddedCommonMetadata) {
        this.embeddedCommonMetadata = embeddedCommonMetadata;
    }

    @Override
    public MetadataMergeAction getMergeAction() {
        return this.mergeAction;
    }

    public void setMergeAction(MetadataMergeAction mergeAction) {
        this.mergeAction = mergeAction;
    }

    protected <T extends MetadataCommon> List<T> mergeLists(List<T> embeddedList, List<T> localList) {
        if (localList == null) {
            return new ArrayList<T>(embeddedList);
        }
        ArrayList<MetadataCommon> mergedList = new ArrayList<MetadataCommon>(embeddedList.size() + localList.size());
        HashMap<Object, MetadataCommon> localObjectMap = new HashMap<Object, MetadataCommon>(localList.size());
        for (MetadataCommon item : localList) {
            if (item instanceof MetadataCommonInternal) {
                localObjectMap.put(((MetadataCommonInternal)item).getUniqueKeyForMerging(), item);
                continue;
            }
            localObjectMap.put(item.getName(), item);
        }
        for (MetadataCommon item : embeddedList) {
            MetadataCommon localItem;
            Object mergeKey = item.getName();
            if (item instanceof MetadataCommonInternal) {
                mergeKey = ((MetadataCommonInternal)item).getUniqueKeyForMerging();
            }
            if ((localItem = (MetadataCommon)localObjectMap.get(mergeKey)) == null) {
                mergedList.add(item);
                continue;
            }
            if (localItem.getMergeAction() == MetadataMergeAction.MERGE) {
                if (localItem instanceof MetadataCommonInternal) {
                    ((MetadataCommonInternal)localItem).setEmbeddedCommonMetadata(item);
                    if (localItem instanceof DataObjectAttributeInternal && item instanceof DataObjectAttribute) {
                        ((DataObjectAttributeInternal)localItem).setEmbeddedAttribute((DataObjectAttribute)item);
                    }
                } else {
                    LOG.warn("List item implementation class (" + localItem.getClass().getName() + ") does not implement the MetadataCommonInternal interface.  It can not merge in previously extracted metadata.");
                }
                mergedList.add(localItem);
            } else if (localItem.getMergeAction() == MetadataMergeAction.REPLACE) {
                mergedList.add(localItem);
            } else if (localItem.getMergeAction() != MetadataMergeAction.REMOVE) {
                if (localItem.getMergeAction() == MetadataMergeAction.NO_OVERRIDE) {
                    mergedList.add(item);
                } else {
                    LOG.warn("Unsupported MetadataMergeAction: " + String.valueOf((Object)localItem.getMergeAction()) + " on " + String.valueOf(localItem));
                }
            }
            localObjectMap.remove(mergeKey);
        }
        mergedList.addAll(localObjectMap.values());
        return mergedList;
    }
}

