/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.data.platform.DatabasePlatformInfo;
import org.kuali.rice.krad.data.platform.DatabasePlatforms;
import org.kuali.rice.krad.data.platform.UnsupportedDatabasePlatformException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.AbstractSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;

public final class MaxValueIncrementerFactory {
    private static final String ID_COLUMN_NAME = "ID";
    public static final String PLATFORM_INCREMENTER_PREFIX = "rice.krad.data.platform.incrementer.";
    private static final Map<DataSource, ConcurrentMap<String, DataFieldMaxValueIncrementer>> cache = Collections.synchronizedMap(new IdentityHashMap(8));

    private MaxValueIncrementerFactory() {
    }

    public static DataFieldMaxValueIncrementer getIncrementer(DataSource dataSource, String incrementerName) {
        DataFieldMaxValueIncrementer incrementer;
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource must not be null");
        }
        if (StringUtils.isBlank((String)incrementerName)) {
            throw new IllegalArgumentException("Incrementer name must not be null or blank");
        }
        ConcurrentMap<String, DataFieldMaxValueIncrementer> incrementerCache = cache.get(dataSource);
        if (incrementerCache == null) {
            cache.put(dataSource, new ConcurrentHashMap(8, 0.9f, 1));
            incrementerCache = cache.get(dataSource);
        }
        if ((incrementer = (DataFieldMaxValueIncrementer)incrementerCache.get(incrementerName.toUpperCase())) == null && (incrementer = incrementerCache.putIfAbsent(incrementerName.toUpperCase(), MaxValueIncrementerFactory.createIncrementer(dataSource, incrementerName))) == null) {
            incrementer = (DataFieldMaxValueIncrementer)incrementerCache.get(incrementerName.toUpperCase());
        }
        return incrementer;
    }

    private static DataFieldMaxValueIncrementer createIncrementer(DataSource dataSource, String incrementerName) {
        DatabasePlatformInfo platformInfo = DatabasePlatforms.detectPlatform(dataSource);
        Object incrementer = MaxValueIncrementerFactory.getCustomizedIncrementer(platformInfo, dataSource, incrementerName, ID_COLUMN_NAME);
        if (incrementer != null) {
            return incrementer;
        }
        if ("Oracle".equalsIgnoreCase(platformInfo.getName())) {
            incrementer = new OracleSequenceMaxValueIncrementer(dataSource, incrementerName);
        } else if ("MySQL".equalsIgnoreCase(platformInfo.getName()) || "MariaDB".equalsIgnoreCase(platformInfo.getName())) {
            incrementer = new EnhancedMySQLMaxValueIncrementer(dataSource, incrementerName, ID_COLUMN_NAME);
        }
        if (incrementer == null) {
            throw new UnsupportedDatabasePlatformException(platformInfo);
        }
        if (incrementer instanceof InitializingBean) {
            try {
                ((InitializingBean)incrementer).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new DataAccessResourceFailureException("Failed to initialize max value incrementer for given datasource and incrementer. dataSource=" + dataSource.toString() + ", incrementerName = " + incrementerName, (Throwable)e);
            }
        }
        return incrementer;
    }

    private static DataFieldMaxValueIncrementer getCustomizedIncrementer(DatabasePlatformInfo platformInfo, DataSource dataSource, String incrementerName, String columnName) {
        if (platformInfo == null) {
            throw new IllegalArgumentException("DataSource platform must not be null");
        }
        if (ConfigContext.getCurrentContextConfig() == null) {
            return null;
        }
        Map incrementerPropToIncrementer = ConfigContext.getCurrentContextConfig().getPropertiesWithPrefix(PLATFORM_INCREMENTER_PREFIX, true);
        String platformNameVersion = platformInfo.getName().toLowerCase() + "." + platformInfo.getMajorVersion();
        String incrementerClassName = "";
        if (incrementerPropToIncrementer.containsKey(platformNameVersion)) {
            incrementerClassName = (String)incrementerPropToIncrementer.get(platformNameVersion);
        } else if (incrementerPropToIncrementer.containsKey(platformInfo.getName().toLowerCase())) {
            incrementerClassName = (String)incrementerPropToIncrementer.get(platformInfo.getName().toLowerCase());
        }
        if (StringUtils.isNotBlank((String)incrementerClassName)) {
            try {
                Class<?> incrementerClass = Class.forName(incrementerClassName);
                if (AbstractSequenceMaxValueIncrementer.class.isAssignableFrom(incrementerClass)) {
                    AbstractSequenceMaxValueIncrementer abstractSequenceMaxValueIncrementer = (AbstractSequenceMaxValueIncrementer)incrementerClass.newInstance();
                    abstractSequenceMaxValueIncrementer.setDataSource(dataSource);
                    abstractSequenceMaxValueIncrementer.setIncrementerName(incrementerName);
                    return abstractSequenceMaxValueIncrementer;
                }
                if (AbstractColumnMaxValueIncrementer.class.isAssignableFrom(incrementerClass)) {
                    AbstractColumnMaxValueIncrementer abstractColumnMaxValueIncrementer = (AbstractColumnMaxValueIncrementer)incrementerClass.newInstance();
                    abstractColumnMaxValueIncrementer.setDataSource(dataSource);
                    abstractColumnMaxValueIncrementer.setIncrementerName(incrementerName);
                    abstractColumnMaxValueIncrementer.setColumnName(columnName);
                    return abstractColumnMaxValueIncrementer;
                }
                throw new InstantiationError("Cannot create incrementer class " + incrementerClassName + " it has to extend AbstractSequenceMaxValueIncrementer or AbstractColumnMaxValueIncrementer");
            }
            catch (Exception e) {
                throw new InstantiationError("Could not instantiate custom incrementer " + incrementerClassName);
            }
        }
        return null;
    }

    static final class EnhancedMySQLMaxValueIncrementer
    extends AbstractColumnMaxValueIncrementer {
        private JdbcTemplate template;

        private EnhancedMySQLMaxValueIncrementer() {
        }

        private EnhancedMySQLMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnName) {
            super(dataSource, incrementerName, columnName);
        }

        public synchronized void afterPropertiesSet() {
            super.afterPropertiesSet();
            this.template = new JdbcTemplate(this.getDataSource());
        }

        protected synchronized long getNextKey() throws DataAccessException {
            return (Long)this.template.execute(con -> {
                try (Statement statement = con.createStatement();){
                    statement.executeUpdate("INSERT INTO " + this.getIncrementerName() + " VALUES (NULL)");
                    try (ResultSet resultSet = statement.executeQuery("SELECT LAST_INSERT_ID()");){
                        if (resultSet != null && resultSet.next()) {
                            Long l = resultSet.getLong(1);
                            return l;
                        }
                        throw new IncorrectResultSizeDataAccessException("Failed to get last_insert_id() for sequence incrementer table '" + this.getIncrementerName() + "'", 1);
                    }
                }
            });
        }
    }
}

